/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph;

import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.odpi.openmetadata.accessservices.assetlineage.LineageEntity;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphVertexMapper {
    private static final Logger log = LoggerFactory.getLogger(GraphVertexMapper.class);

    public void mapEntityToVertex(LineageEntity lineageEntity, Vertex vertex) {
        this.mapEntitySummaryToVertex(lineageEntity, vertex);
        Map instanceProperties = lineageEntity.getProperties();
        if (instanceProperties != null) {
            for (Map.Entry entry : instanceProperties.entrySet()) {
                String key = "ve" + (String)entry.getKey();
                vertex.property(key, entry.getValue());
            }
        }
    }

    public void mapEntitySummaryToVertex(LineageEntity lineageEntity, Vertex vertex) {
        String methodName = "mapEntitySummaryToVertex";
        boolean missingAttribute = false;
        String missingAttributeName = null;
        if (lineageEntity.getGuid() != null) {
            vertex.property("veguid", (Object)lineageEntity.getGuid());
        } else {
            log.debug("{} missing attribute: guid", (Object)methodName);
            missingAttribute = true;
            missingAttributeName = "guid";
        }
        String instanceType = lineageEntity.getTypeDefName();
        if (instanceType != null) {
            vertex.property("vename", (Object)instanceType);
        } else {
            log.debug("{} missing attribute: type name", (Object)methodName);
            missingAttribute = true;
            missingAttributeName = "type or typeDefName";
        }
        if (missingAttribute) {
            log.error("{} entity is missing core attribute {}", (Object)methodName, (Object)missingAttributeName);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.ENTITY_PROPERTIES_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(lineageEntity.getGuid(), methodName, this.getClass().getName());
            throw new JanusConnectorException(this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        vertex.property("veversion", (Object)lineageEntity.getVersion());
        if (lineageEntity.getCreatedBy() != null) {
            vertex.property("vecreatedBy", (Object)lineageEntity.getCreatedBy());
        } else {
            this.removeProperty(vertex, "vecreatedBy");
        }
        if (lineageEntity.getCreateTime() != null) {
            vertex.property("vecreateTime", (Object)lineageEntity.getCreateTime());
        } else {
            this.removeProperty(vertex, "vecreateTime");
        }
        if (lineageEntity.getUpdatedBy() != null) {
            vertex.property("veupdatedBy", (Object)lineageEntity.getUpdatedBy());
        } else {
            this.removeProperty(vertex, "veupdatedBy");
        }
        if (lineageEntity.getUpdateTime() != null) {
            vertex.property("veupdateTime", (Object)lineageEntity.getUpdateTime());
        } else {
            this.removeProperty(vertex, "veupdateTime");
        }
    }

    private void removeProperty(Vertex vertex, String qualifiedPropName) {
        VertexProperty vp = vertex.property(qualifiedPropName);
        if (vp != null) {
            vp.remove();
        }
    }
}

