/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph;

import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.GraphConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingFactory {
    private static final Logger log = LoggerFactory.getLogger(IndexingFactory.class);
    private JanusGraph graph;

    protected void createCompositeIndexForProperty(String propertyName, String propertyKeyName, boolean unique, JanusGraph graph, Class type) {
        String indexName = "vertexIndexComposite" + propertyKeyName;
        log.info("INDEX CREATE {}", (Object)indexName);
        this.graph = graph;
        this.checkIndex(indexName, propertyName, propertyKeyName, unique, type);
    }

    private void checkIndex(String indexName, String propertyName, String propertyKeyName, boolean unique, Class type) {
        String methodName = "getIndex";
        JanusGraphManagement management = this.graph.openManagement();
        JanusGraphIndex existingIndex = management.getGraphIndex(indexName);
        if (existingIndex != null) {
            log.info("{} index {} already exists", (Object)"getIndex", (Object)indexName);
            management.rollback();
            return;
        }
        this.createIndex(management, indexName, propertyName, propertyKeyName, unique, type);
    }

    private void createIndex(JanusGraphManagement management, String indexName, String propertyName, String propertyKeyName, boolean unique, Class type) {
        PropertyKey propertyKey;
        Class<?> clazz;
        String methodName = "createIndex";
        String className = GraphConstants.corePropertyTypes.get(propertyName);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("{} class not found for property {}", (Object)"createIndex", (Object)propertyName);
            log.error("{} NO INDEX CREATED for property {}", (Object)"createIndex", (Object)propertyName);
            return;
        }
        boolean oldKey = false;
        PropertyKey existingPropertyKey = management.getPropertyKey(propertyKeyName);
        if (existingPropertyKey != null) {
            log.debug("{} property key already exists for property {}", (Object)"createIndex", (Object)propertyKeyName);
            propertyKey = existingPropertyKey;
            oldKey = true;
        } else {
            log.debug("{} make property key for property {}", (Object)"createIndex", (Object)propertyKeyName);
            propertyKey = management.makePropertyKey(propertyKeyName).dataType(clazz).make();
        }
        this.buildIndex(management, indexName, propertyKey, unique, oldKey, type);
    }

    private void buildIndex(JanusGraphManagement management, String indexName, PropertyKey propertyKey, boolean unique, boolean oldKey, Class type) {
        if (type.equals(Vertex.class)) {
            JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, type).addKey(propertyKey);
            if (unique) {
                indexBuilder.unique();
            }
            JanusGraphIndex index = indexBuilder.buildCompositeIndex();
            if (unique) {
                management.setConsistency((JanusGraphSchemaElement)index, ConsistencyModifier.LOCK);
            }
            management.commit();
        } else if (type.equals(Edge.class)) {
            JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, Edge.class).addKey(propertyKey);
            indexBuilder.buildCompositeIndex();
            management.commit();
        } else {
            management.rollback();
            return;
        }
        this.enableIndex(management, indexName, oldKey, type);
    }

    private void enableIndex(JanusGraphManagement management, String indexName, boolean oldKey, Class type) {
        String methodName = "enableIndex";
        try {
            if (oldKey) {
                ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call();
                management = this.graph.openManagement();
                JanusGraphIndex index = management.getGraphIndex(indexName);
                management.updateIndex((Index)index, SchemaAction.REINDEX);
                management.commit();
            }
            log.debug("{} awaitGraphIndexStatus ENABLED for {}", (Object)"enableIndex", (Object)indexName);
            ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        }
        catch (Exception e) {
            log.error("{} caught interrupted exception from awaitGraphIndexStatus ENABLED {}", (Object)"enableIndex", (Object)e);
            management.rollback();
        }
    }
}

