/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.maingraph;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.graphdb.tinkerpop.io.graphson.JanusGraphSONModuleV2d0;
import org.odpi.openmetadata.accessservices.assetlineage.model.event.LineageEvent;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.governanceservers.openlineage.maingraphstore.MainGraphConnectorBase;
import org.odpi.openmetadata.governanceservers.openlineage.model.GraphName;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageEdge;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.model.View;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.berkeleydb.BerkeleyBufferJanusFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.berkeleydb.BerkeleyJanusFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph.GraphVertexMapper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.maingraph.FactoryForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainGraphConnector
extends MainGraphConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(MainGraphConnector.class);
    private JanusGraph bufferGraph;
    private GraphVertexMapper graphVertexMapper = new GraphVertexMapper();
    private JanusGraph mainGraph;
    private JanusGraph historyGraph;
    private JanusGraph mockGraph;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        this.initializeGraphDB();
    }

    public void start() throws ConnectorCheckedException {
        super.start();
    }

    private void initializeGraphDB() {
        String graphDB;
        switch (graphDB = this.connectionProperties.getConfigurationProperties().get("graphDB").toString()) {
            case "berkeleydb": {
                try {
                    this.mainGraph = BerkeleyJanusFactory.openMainGraph();
                    this.bufferGraph = BerkeleyBufferJanusFactory.openBufferGraph();
                    this.historyGraph = BerkeleyJanusFactory.openHistoryGraph();
                    this.mockGraph = BerkeleyJanusFactory.openMockGraph();
                }
                catch (Exception e) {
                    log.error("{} Could not open graph database", (Object)"JanusConnector");
                }
                break;
            }
            case "cassandra": {
                FactoryForTesting factoryForTesting = new FactoryForTesting();
                this.mainGraph = factoryForTesting.openBufferGraph(this.connectionProperties);
                break;
            }
        }
    }

    public void addEntity(LineageEvent lineageEvent) {
    }

    public LineageResponse lineage(String graphName, Scope scope, View view, String guid) {
        JanusGraph graph = this.getJanusGraph(graphName);
        switch (scope) {
            case SOURCE_AND_DESTINATION: {
                return this.sourceAndDestination((Graph)graph, view, guid);
            }
            case END_TO_END: {
                return this.endToEnd((Graph)graph, view, guid);
            }
            case ULTIMATE_SOURCE: {
                return this.ultimateSource((Graph)graph, view, guid);
            }
            case ULTIMATE_DESTINATION: {
                return this.ultimateDestination((Graph)graph, view, guid);
            }
            case GLOSSARY: {
                return this.glossary((Graph)graph, guid);
            }
        }
        log.error(scope + " is not a valid lineage query");
        return null;
    }

    private LineageResponse endToEnd(Graph graph, View view, String guid) {
        GraphTraversalSource g = graph.traversal();
        String edgeLabel = this.getEdgeLabel(view);
        Graph endToEndGraph = (Graph)g.V(new Object[0]).has("veguid", (Object)guid).union(new Traversal[]{__.until((Traversal)__.inE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.inE((String[])new String[]{edgeLabel}).subgraph("subGraph").outV()), __.until((Traversal)__.outE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.outE((String[])new String[]{edgeLabel}).subgraph("subGraph").inV())}).cap("subGraph", new String[0]).next();
        LineageResponse lineageResponse = this.getLineageResponse(endToEndGraph);
        return lineageResponse;
    }

    private LineageEdge abstractEdge(Edge originalEdge) {
        String sourceNodeID = originalEdge.outVertex().property("veguid").value().toString();
        String destinationNodeId = originalEdge.inVertex().property("veguid").value().toString();
        LineageEdge lineageEdge = new LineageEdge(originalEdge.label(), sourceNodeID, destinationNodeId);
        return lineageEdge;
    }

    private LineageVertex abstractVertex(Vertex originalVertex) {
        String nodeID = originalVertex.property("veguid").value().toString();
        String nodeType = originalVertex.label();
        String displayName = originalVertex.property("vedisplayName").value().toString();
        String guid = originalVertex.property("veguid").value().toString();
        LineageVertex lineageVertex = new LineageVertex(nodeID, nodeType, displayName, guid);
        Map<String, String> attributes = null;
        switch (nodeType) {
            case "column": {
                attributes = this.setColumnProperties(originalVertex, lineageVertex);
                break;
            }
            case "table": {
                attributes = this.setTableProperties(originalVertex, lineageVertex);
                break;
            }
            case "process": {
                attributes = this.setProcessProperties(originalVertex, lineageVertex);
                break;
            }
            case "subProcess": {
                attributes = this.setSubProcessProperties(originalVertex, lineageVertex);
                break;
            }
            case "glossaryTerm": {
                attributes = this.setGlossaryTermProperties(originalVertex, lineageVertex);
                break;
            }
        }
        lineageVertex.setAttributes(attributes);
        return lineageVertex;
    }

    private Map<String, String> setSubProcessProperties(Vertex originalVertex, LineageVertex lineageVertex) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        return attributes;
    }

    private Map<String, String> setProcessProperties(Vertex originalVertex, LineageVertex lineageVertex) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        return attributes;
    }

    private Map<String, String> setGlossaryTermProperties(Vertex originalVertex, LineageVertex lineageVertex) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        return attributes;
    }

    private Map<String, String> setTableProperties(Vertex originalVertex, LineageVertex lineageVertex) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String originalGlossaryTerm = originalVertex.property("veglossaryTerm").value().toString();
        if (originalGlossaryTerm != null) {
            attributes.put("glossaryTerm", originalGlossaryTerm);
        }
        return attributes;
    }

    private Map<String, String> setColumnProperties(Vertex originalVertex, LineageVertex lineageVertex) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String originalGlossaryTerm = originalVertex.property("veglossaryTerm").value().toString();
        if (originalGlossaryTerm != null) {
            attributes.put("glossaryTerm", originalGlossaryTerm);
        }
        return attributes;
    }

    private LineageResponse ultimateSource(Graph graph, View view, String guid) {
        GraphTraversalSource g = graph.traversal();
        String edgeLabel = this.getEdgeLabel(view);
        List sourcesList = g.V(new Object[0]).has("veguid", (Object)guid).until((Traversal)__.inE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.inE((String[])new String[]{edgeLabel}).outV().simplePath()).dedup(new String[0]).toList();
        Vertex originalQueriedVertex = (Vertex)g.V(new Object[0]).has("veguid", (Object)guid).next();
        ArrayList<LineageVertex> lineageVertices = new ArrayList<LineageVertex>();
        ArrayList<LineageEdge> lineageEdges = new ArrayList<LineageEdge>();
        LineageVertex queriedVertex = this.abstractVertex(originalQueriedVertex);
        lineageVertices.add(queriedVertex);
        this.addSourceCondensation(sourcesList, lineageVertices, lineageEdges, originalQueriedVertex, queriedVertex);
        LineageVerticesAndEdges lineageVerticesAndEdges = new LineageVerticesAndEdges(lineageVertices, lineageEdges);
        LineageResponse lineageResponse = new LineageResponse(lineageVerticesAndEdges);
        return lineageResponse;
    }

    private LineageResponse ultimateDestination(Graph graph, View view, String guid) {
        GraphTraversalSource g = graph.traversal();
        String edgeLabel = this.getEdgeLabel(view);
        List destinationsList = g.V(new Object[0]).has("veguid", (Object)guid).until((Traversal)__.outE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.outE((String[])new String[]{edgeLabel}).inV().simplePath()).dedup(new String[0]).toList();
        Vertex originalQueriedVertex = (Vertex)g.V(new Object[0]).has("veguid", (Object)guid).next();
        LineageVertex queriedVertex = this.abstractVertex(originalQueriedVertex);
        ArrayList<LineageVertex> lineageVertices = new ArrayList<LineageVertex>();
        ArrayList<LineageEdge> lineageEdges = new ArrayList<LineageEdge>();
        lineageVertices.add(queriedVertex);
        this.addDestinationCondensation(destinationsList, lineageVertices, lineageEdges, originalQueriedVertex, queriedVertex);
        LineageVerticesAndEdges lineageVerticesAndEdges = new LineageVerticesAndEdges(lineageVertices, lineageEdges);
        LineageResponse lineageResponse = new LineageResponse(lineageVerticesAndEdges);
        return lineageResponse;
    }

    private LineageResponse sourceAndDestination(Graph graph, View view, String guid) {
        GraphTraversalSource g = graph.traversal();
        String edgeLabel = this.getEdgeLabel(view);
        List sourcesList = g.V(new Object[0]).has("veguid", (Object)guid).until((Traversal)__.inE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.inE((String[])new String[]{edgeLabel}).outV().simplePath()).dedup(new String[0]).toList();
        List destinationsList = g.V(new Object[0]).has("veguid", (Object)guid).until((Traversal)__.outE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.outE((String[])new String[]{edgeLabel}).inV().simplePath()).dedup(new String[0]).toList();
        Vertex originalQueriedVertex = (Vertex)g.V(new Object[0]).has("veguid", (Object)guid).next();
        LineageVertex queriedVertex = this.abstractVertex(originalQueriedVertex);
        ArrayList<LineageVertex> lineageVertices = new ArrayList<LineageVertex>();
        ArrayList<LineageEdge> lineageEdges = new ArrayList<LineageEdge>();
        lineageVertices.add(queriedVertex);
        this.addSourceCondensation(sourcesList, lineageVertices, lineageEdges, originalQueriedVertex, queriedVertex);
        this.addDestinationCondensation(destinationsList, lineageVertices, lineageEdges, originalQueriedVertex, queriedVertex);
        LineageVerticesAndEdges lineageVerticesAndEdges = new LineageVerticesAndEdges(lineageVertices, lineageEdges);
        LineageResponse lineageResponse = new LineageResponse(lineageVerticesAndEdges);
        return lineageResponse;
    }

    private void addSourceCondensation(List<Vertex> sourcesList, List<LineageVertex> lineageVertices, List<LineageEdge> lineageEdges, Vertex originalQueriedVertex, LineageVertex queriedVertex) {
        if (!sourcesList.get(0).property("veguid").equals(originalQueriedVertex.property("veguid"))) {
            LineageVertex condensedVertex = new LineageVertex("condensedSource", "condensedNode", "Condensed", "");
            lineageVertices.add(condensedVertex);
            for (Vertex originalVertex : sourcesList) {
                LineageVertex newVertex = this.abstractVertex(originalVertex);
                LineageEdge newEdge = new LineageEdge("condensed", newVertex.getNodeID(), condensedVertex.getNodeID());
                if (newVertex != null) {
                    lineageVertices.add(newVertex);
                }
                if (newEdge == null) continue;
                lineageEdges.add(newEdge);
            }
            LineageEdge sourceEdge = new LineageEdge("condensed", condensedVertex.getNodeID(), queriedVertex.getNodeID());
            lineageEdges.add(sourceEdge);
        }
    }

    private void addDestinationCondensation(List<Vertex> destinationsList, List<LineageVertex> lineageVertices, List<LineageEdge> lineageEdges, Vertex originalQueriedVertex, LineageVertex queriedVertex) {
        if (!destinationsList.get(0).property("veguid").equals(originalQueriedVertex.property("veguid"))) {
            LineageVertex condensedDestinationVertex = new LineageVertex("condensedDestination", "condensedNode", "Condensed", "");
            for (Vertex originalVertex : destinationsList) {
                LineageVertex newVertex = this.abstractVertex(originalVertex);
                LineageEdge newEdge = new LineageEdge("condensed", condensedDestinationVertex.getNodeID(), newVertex.getNodeID());
                if (newVertex != null) {
                    lineageVertices.add(newVertex);
                }
                if (newEdge == null) continue;
                lineageEdges.add(newEdge);
            }
            LineageEdge destinationEdge = new LineageEdge("condensed", queriedVertex.getNodeID(), condensedDestinationVertex.getNodeID());
            lineageVertices.add(condensedDestinationVertex);
            lineageEdges.add(destinationEdge);
        }
    }

    private LineageResponse glossary(Graph graph, String guid) {
        GraphTraversalSource g = graph.traversal();
        Graph subGraph = (Graph)g.V(new Object[0]).has("veguid", (Object)guid).emit().repeat((Traversal)__.bothE((String[])new String[]{"synonym"}).subgraph("subGraph").simplePath().otherV()).inE(new String[]{"semanticAssignment"}).subgraph("subGraph").outV().cap("subGraph", new String[0]).next();
        LineageResponse lineageResponse = this.getLineageResponse(subGraph);
        return lineageResponse;
    }

    private LineageResponse getLineageResponse(Graph subGraph) {
        Iterator originalVertices = subGraph.vertices(new Object[0]);
        Iterator originalEdges = subGraph.edges(new Object[0]);
        ArrayList<LineageVertex> lineageVertices = new ArrayList<LineageVertex>();
        ArrayList<LineageEdge> lineageEdges = new ArrayList<LineageEdge>();
        while (originalVertices.hasNext()) {
            LineageVertex newVertex = this.abstractVertex((Vertex)originalVertices.next());
            if (newVertex == null) continue;
            lineageVertices.add(newVertex);
        }
        while (originalEdges.hasNext()) {
            LineageEdge newLineageEdge = this.abstractEdge((Edge)originalEdges.next());
            if (newLineageEdge == null) continue;
            lineageEdges.add(newLineageEdge);
        }
        LineageVerticesAndEdges lineageVerticesAndEdges = new LineageVerticesAndEdges(lineageVertices, lineageEdges);
        LineageResponse lineageResponse = new LineageResponse(lineageVerticesAndEdges);
        return lineageResponse;
    }

    private String getEdgeLabel(View view) {
        String edgeLabel = "";
        switch (view) {
            case TABLE_VIEW: {
                edgeLabel = "processTable";
                break;
            }
            case COLUMN_VIEW: {
                edgeLabel = "processColumn";
                break;
            }
            default: {
                log.error(view + " is not a valid lineage view");
            }
        }
        return edgeLabel;
    }

    public void dumpGraph(String graphName) {
        JanusGraph graph = this.getJanusGraph(graphName);
        try {
            ((GraphMLIo)graph.io(IoCore.graphml())).writeGraph("graph-" + graphName + ".graphml");
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public String exportGraph(String graphName) {
        JanusGraph graph = this.getJanusGraph(graphName);
        return this.janusGraphToGraphson((Graph)graph);
    }

    private String janusGraphToGraphson(Graph graph) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GraphSONMapper mapper = GraphSONMapper.build().addCustomModule((SimpleModule)JanusGraphSONModuleV2d0.getInstance()).create();
        GraphSONWriter writer = GraphSONWriter.build().mapper((Mapper)mapper).wrapAdjacencyList(true).create();
        try {
            writer.writeGraph((OutputStream)out, graph);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return ((Object)out).toString();
    }

    private JanusGraph getJanusGraph(String graphNameText) {
        JanusGraph graph = null;
        GraphName graphName = GraphName.fromString((String)graphNameText);
        switch (graphName) {
            case MAIN: {
                graph = this.mainGraph;
                break;
            }
            case BUFFER: {
                graph = this.bufferGraph;
                break;
            }
            case HISTORY: {
                graph = this.historyGraph;
                break;
            }
            case MOCK: {
                graph = this.mockGraph;
                break;
            }
            default: {
                log.error(graphNameText + " is not a valid graph");
            }
        }
        return graph;
    }

    public Object getMainGraph() {
        return this.mainGraph;
    }
}

