/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.resource.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.controls.JDBCConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ffdc.JDBCAuditCode;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ffdc.JDBCErrorCode;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.JDBCDataValue;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCResourceConnector
extends ConnectorBase
implements AuditLoggingComponent {
    private AuditLog auditLog = null;
    private String jdbcDatabaseName = null;
    private String jdbcDatabaseURL = null;
    private Connection jdbcConnection = null;
    private final List<JDBCConnectorAsDataSource> knownDataSources = new ArrayList<JDBCConnectorAsDataSource>();
    private static final Logger log = LoggerFactory.getLogger(JDBCResourceConnector.class);

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.jdbcDatabaseURL = endpoint.getAddress();
        }
        if (this.jdbcDatabaseURL == null) {
            throw new ConnectorCheckedException(JDBCErrorCode.NULL_URL.getMessageDefinition(this.connectionProperties.getConnectionName()), ((Object)((Object)this)).getClass().getName(), "start");
        }
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        if (configurationProperties != null && configurationProperties.get(JDBCConfigurationProperty.DATABASE_NAME.getName()) != null) {
            this.jdbcDatabaseName = configurationProperties.get(JDBCConfigurationProperty.DATABASE_NAME.getName()).toString();
        }
        if (this.jdbcDatabaseName == null) {
            this.jdbcDatabaseName = this.jdbcDatabaseURL;
        }
        if (configurationProperties != null) {
            Object driverManagerClassName;
            Object connectionTimeoutOption;
            if (configurationProperties.get(JDBCConfigurationProperty.JDBC_CONNECTION_TIMEOUT.getName()) != null && (connectionTimeoutOption = configurationProperties.get(JDBCConfigurationProperty.JDBC_CONNECTION_TIMEOUT.getName())) != null) {
                int connectionTimeout = Integer.parseInt(connectionTimeoutOption.toString());
                DriverManager.setLoginTimeout(connectionTimeout);
            }
            if ((driverManagerClassName = configurationProperties.get(JDBCConfigurationProperty.JDBC_DRIVER_MANAGER_CLASS_NAME.getName())) != null) {
                try {
                    Class.forName(driverManagerClassName.toString());
                }
                catch (ClassNotFoundException error) {
                    throw new ConnectorCheckedException(JDBCErrorCode.BAD_DRIVER_MANAGER_CLASS.getMessageDefinition(this.jdbcDatabaseName, driverManagerClassName.toString(), this.connectionProperties.getConnectionName(), error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start");
                }
            }
            try {
                this.jdbcConnection = this.getDataSource().getConnection();
            }
            catch (SQLException sqlException) {
                throw new ConnectorCheckedException(JDBCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectionProperties.getConnectionName(), sqlException.getClass().getName(), "start", sqlException.getMessage()), ((Object)((Object)this)).getClass().getName(), "start");
            }
        }
    }

    public String getDatabaseName() {
        return this.jdbcDatabaseName;
    }

    public synchronized DataSource getDataSource() {
        JDBCConnectorAsDataSource dataSource = new JDBCConnectorAsDataSource(this.jdbcDatabaseName, this.auditLog);
        this.knownDataSources.add(dataSource);
        return dataSource;
    }

    public void addDatabaseDefinitions(List<String> ddlStatements) throws PropertyServerException {
        if (ddlStatements != null && !ddlStatements.isEmpty()) {
            for (String ddlStatement : ddlStatements) {
                if (ddlStatement == null) continue;
                this.issueSQLCommand(ddlStatement);
            }
        }
    }

    public void issueSQLCommand(String sqlCommand) throws PropertyServerException {
        String methodName = "issueSQLCommand";
        try {
            if (this.jdbcConnection.isClosed()) {
                this.jdbcConnection = DriverManager.getConnection(this.jdbcDatabaseURL);
            }
            log.debug(sqlCommand);
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(sqlCommand);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sqlException) {
            throw new PropertyServerException(JDBCErrorCode.UNEXPECTED_SQL_EXCEPTION.getMessageDefinition(this.jdbcDatabaseName, sqlCommand, "issueSQLCommand", sqlException.getMessage()), ((Object)((Object)this)).getClass().getName(), "issueSQLCommand", (Throwable)sqlException);
        }
    }

    public Map<String, JDBCDataValue> getLatestRow(String tableName, String identifierColumnName, String identifierColumnValue, String timestampColumnName, Map<String, Integer> columnNameTypeMap) throws PropertyServerException {
        String methodName = "getLatestRow";
        String sqlCommand = "SELECT * FROM " + tableName + " WHERE " + identifierColumnName + " = ? AND " + timestampColumnName + " = (SELECT MAX(" + timestampColumnName + ") FROM " + tableName + " WHERE " + identifierColumnName + " = ?)";
        try {
            if (this.jdbcConnection.isClosed()) {
                this.jdbcConnection = DriverManager.getConnection(this.jdbcDatabaseURL);
            }
            log.debug(sqlCommand);
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(sqlCommand);
            preparedStatement.setString(1, identifierColumnValue);
            preparedStatement.setString(2, identifierColumnValue);
            ResultSet resultSet = preparedStatement.executeQuery();
            Map<String, JDBCDataValue> results = this.getRowFromResultSet(resultSet, columnNameTypeMap);
            resultSet.close();
            preparedStatement.close();
            return results;
        }
        catch (SQLException sqlException) {
            throw new PropertyServerException(JDBCErrorCode.UNEXPECTED_SQL_EXCEPTION.getMessageDefinition(this.jdbcDatabaseName, sqlCommand, "getLatestRow", sqlException.getMessage()), ((Object)((Object)this)).getClass().getName(), "getLatestRow", (Throwable)sqlException);
        }
    }

    public Map<String, JDBCDataValue> getMatchingRow(String tableName, String whereClause, Map<String, Integer> columnNameTypeMap) throws PropertyServerException {
        String methodName = "getMatchingRow";
        String sqlCommand = "SELECT * FROM " + tableName + " WHERE " + whereClause;
        try {
            if (this.jdbcConnection.isClosed()) {
                this.jdbcConnection = DriverManager.getConnection(this.jdbcDatabaseURL);
            }
            log.debug(sqlCommand);
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(sqlCommand);
            ResultSet resultSet = preparedStatement.executeQuery();
            Map<String, JDBCDataValue> results = this.getRowFromResultSet(resultSet, columnNameTypeMap);
            resultSet.close();
            preparedStatement.close();
            return results;
        }
        catch (SQLException sqlException) {
            throw new PropertyServerException(JDBCErrorCode.UNEXPECTED_SQL_EXCEPTION.getMessageDefinition(this.jdbcDatabaseName, sqlCommand, "getMatchingRow", sqlException.getMessage()), ((Object)((Object)this)).getClass().getName(), "getMatchingRow", (Throwable)sqlException);
        }
    }

    public List<Map<String, JDBCDataValue>> getMatchingRows(String tableName, String whereClause, Map<String, Integer> columnNameTypeMap) throws PropertyServerException {
        String methodName = "getMatchingRows";
        String sqlCommand = "SELECT * FROM " + tableName + " WHERE " + whereClause;
        try {
            if (this.jdbcConnection.isClosed()) {
                this.jdbcConnection = DriverManager.getConnection(this.jdbcDatabaseURL);
            }
            log.debug(sqlCommand);
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(sqlCommand);
            ResultSet resultSet = preparedStatement.executeQuery();
            List<Map<String, JDBCDataValue>> results = this.getRowsFromResultSet(resultSet, columnNameTypeMap);
            resultSet.close();
            preparedStatement.close();
            return results;
        }
        catch (SQLException sqlException) {
            throw new PropertyServerException(JDBCErrorCode.UNEXPECTED_SQL_EXCEPTION.getMessageDefinition(this.jdbcDatabaseName, sqlCommand, "getMatchingRows", sqlException.getMessage()), ((Object)((Object)this)).getClass().getName(), "getMatchingRows", (Throwable)sqlException);
        }
    }

    public List<Map<String, JDBCDataValue>> getMatchingRows(String sqlCommand, Map<String, Integer> columnNameTypeMap) throws PropertyServerException {
        String methodName = "getMatchingRows";
        try {
            if (this.jdbcConnection.isClosed()) {
                this.jdbcConnection = DriverManager.getConnection(this.jdbcDatabaseURL);
            }
            log.debug(sqlCommand);
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(sqlCommand);
            ResultSet resultSet = preparedStatement.executeQuery();
            List<Map<String, JDBCDataValue>> results = this.getRowsFromResultSet(resultSet, columnNameTypeMap);
            resultSet.close();
            preparedStatement.close();
            return results;
        }
        catch (SQLException sqlException) {
            throw new PropertyServerException(JDBCErrorCode.UNEXPECTED_SQL_EXCEPTION.getMessageDefinition(this.jdbcDatabaseName, sqlCommand, "getMatchingRows", sqlException.getMessage()), ((Object)((Object)this)).getClass().getName(), "getMatchingRows", (Throwable)sqlException);
        }
    }

    public List<Map<String, JDBCDataValue>> getRows(String tableName, Map<String, Integer> columnNameTypeMap) throws PropertyServerException {
        String methodName = "geRows";
        String sqlCommand = "SELECT * FROM " + tableName;
        try {
            if (this.jdbcConnection.isClosed()) {
                this.jdbcConnection = DriverManager.getConnection(this.jdbcDatabaseURL);
            }
            log.debug(sqlCommand);
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(sqlCommand);
            ResultSet resultSet = preparedStatement.executeQuery();
            List<Map<String, JDBCDataValue>> results = this.getRowsFromResultSet(resultSet, columnNameTypeMap);
            resultSet.close();
            preparedStatement.close();
            return results;
        }
        catch (SQLException sqlException) {
            throw new PropertyServerException(JDBCErrorCode.UNEXPECTED_SQL_EXCEPTION.getMessageDefinition(this.jdbcDatabaseName, sqlCommand, "geRows", sqlException.getMessage()), ((Object)((Object)this)).getClass().getName(), "geRows", (Throwable)sqlException);
        }
    }

    private Map<String, JDBCDataValue> getRowFromResultSet(ResultSet resultSet, Map<String, Integer> columnNameTypeMap) throws SQLException {
        HashMap<String, JDBCDataValue> row = null;
        if (resultSet.next()) {
            row = new HashMap<String, JDBCDataValue>();
            for (String columnName : columnNameTypeMap.keySet()) {
                JDBCDataValue dataValue = null;
                int sqlType = columnNameTypeMap.get(columnName);
                switch (sqlType) {
                    case 12: {
                        dataValue = new JDBCDataValue(resultSet.getString(columnName), sqlType);
                        break;
                    }
                    case 2003: {
                        dataValue = new JDBCDataValue(resultSet.getArray(columnName), sqlType);
                        break;
                    }
                    case 16: {
                        dataValue = new JDBCDataValue(resultSet.getBoolean(columnName), sqlType);
                        break;
                    }
                    case 91: {
                        dataValue = new JDBCDataValue(resultSet.getDate(columnName), sqlType);
                        break;
                    }
                    case 2: 
                    case 4: {
                        dataValue = new JDBCDataValue(resultSet.getInt(columnName), sqlType);
                        break;
                    }
                    case 93: {
                        dataValue = new JDBCDataValue(resultSet.getTimestamp(columnName), sqlType);
                        break;
                    }
                    case -5: {
                        dataValue = new JDBCDataValue(resultSet.getBigDecimal(columnName), sqlType);
                    }
                }
                if (dataValue == null || dataValue.getDataValue() == null) continue;
                row.put(columnName, dataValue);
            }
        }
        return row;
    }

    private List<Map<String, JDBCDataValue>> getRowsFromResultSet(ResultSet resultSet, Map<String, Integer> columnNameTypeMap) throws SQLException {
        ArrayList<Map<String, JDBCDataValue>> rows = new ArrayList<Map<String, JDBCDataValue>>();
        while (resultSet.next()) {
            HashMap<String, JDBCDataValue> row = new HashMap<String, JDBCDataValue>();
            for (String columnName : columnNameTypeMap.keySet()) {
                JDBCDataValue dataValue = null;
                int sqlType = columnNameTypeMap.get(columnName);
                switch (sqlType) {
                    case 12: {
                        dataValue = new JDBCDataValue(resultSet.getString(columnName), sqlType);
                        break;
                    }
                    case 2003: {
                        dataValue = new JDBCDataValue(resultSet.getArray(columnName), sqlType);
                        break;
                    }
                    case 16: {
                        dataValue = new JDBCDataValue(resultSet.getBoolean(columnName), sqlType);
                        break;
                    }
                    case 91: {
                        dataValue = new JDBCDataValue(resultSet.getDate(columnName), sqlType);
                        break;
                    }
                    case 2: 
                    case 4: {
                        dataValue = new JDBCDataValue(resultSet.getInt(columnName), sqlType);
                        break;
                    }
                    case 93: {
                        dataValue = new JDBCDataValue(resultSet.getTimestamp(columnName), sqlType);
                        break;
                    }
                    case -5: {
                        dataValue = new JDBCDataValue(resultSet.getBigDecimal(columnName), sqlType);
                    }
                }
                if (dataValue == null || dataValue.getDataValue() == null) continue;
                row.put(columnName, dataValue);
            }
            rows.add(row);
        }
        if (!rows.isEmpty()) {
            return rows;
        }
        return null;
    }

    public void insertRowIntoTable(String tableName, Map<String, JDBCDataValue> columnNameValueMap) throws PropertyServerException {
        String methodName = "insertRowIntoTable";
        String sqlCommand = "INSERT INTO " + tableName + this.getInsertColumnList(columnNameValueMap) + " ON CONFLICT DO NOTHING";
        try {
            if (this.jdbcConnection.isClosed()) {
                this.jdbcConnection = DriverManager.getConnection(this.jdbcDatabaseURL);
            }
            log.debug(sqlCommand);
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(sqlCommand);
            int parameterIndex = 1;
            for (String columnName : columnNameValueMap.keySet()) {
                JDBCDataValue jdbcDataValue = columnNameValueMap.get(columnName);
                if (jdbcDataValue.getScaleOrLength() == 0) {
                    preparedStatement.setObject(parameterIndex, jdbcDataValue.getDataValue(), jdbcDataValue.getTargetSQLType());
                } else {
                    preparedStatement.setObject(parameterIndex, jdbcDataValue.getDataValue(), jdbcDataValue.getTargetSQLType(), jdbcDataValue.getScaleOrLength());
                }
                ++parameterIndex;
            }
            int rowsInserted = preparedStatement.executeUpdate();
            if (rowsInserted > 1 && this.auditLog != null) {
                this.auditLog.logMessage("insertRowIntoTable", JDBCAuditCode.UNEXPECTED_ROW_COUNT_FROM_DATABASE.getMessageDefinition(this.jdbcDatabaseName, Integer.toString(rowsInserted), sqlCommand));
            }
            preparedStatement.close();
        }
        catch (SQLException sqlException) {
            throw new PropertyServerException(JDBCErrorCode.UNEXPECTED_SQL_EXCEPTION.getMessageDefinition(this.jdbcDatabaseName, sqlCommand, "insertRowIntoTable", sqlException.getMessage()), ((Object)((Object)this)).getClass().getName(), "insertRowIntoTable", (Throwable)sqlException);
        }
    }

    public void insertRowsIntoTable(String tableName, List<Map<String, JDBCDataValue>> rows) throws PropertyServerException {
        if (rows != null) {
            for (Map<String, JDBCDataValue> row : rows) {
                this.insertRowIntoTable(tableName, row);
            }
        }
    }

    private String getInsertColumnList(Map<String, JDBCDataValue> columnNameValueMap) {
        return " (" + this.getColumnNames(columnNameValueMap) + ") values (" + this.getPlaceholders(columnNameValueMap.size()) + ")";
    }

    private String getColumnNames(Map<String, JDBCDataValue> columnNameValueMap) {
        StringBuilder sqlFragment = new StringBuilder();
        boolean firstColumn = true;
        for (String columnName : columnNameValueMap.keySet()) {
            if (!firstColumn) {
                sqlFragment.append(", ");
            } else {
                firstColumn = false;
            }
            sqlFragment.append(columnName);
        }
        return sqlFragment.toString();
    }

    private String getPlaceholders(int numberOfColumns) {
        StringBuilder sqlFragment = new StringBuilder();
        for (int i = 0; i < numberOfColumns; ++i) {
            sqlFragment.append("?");
            if (i + 1 >= numberOfColumns) continue;
            sqlFragment.append(",");
        }
        return sqlFragment.toString();
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnectConnectors(this.embeddedConnectors);
        this.disconnectKnownDataSources();
        super.disconnect();
    }

    private synchronized void disconnectKnownDataSources() {
        for (JDBCConnectorAsDataSource dataSource : this.knownDataSources) {
            try {
                dataSource.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    private class JDBCConnectorAsDataSource
    implements DataSource {
        private final String databaseName;
        private final AuditLog auditLog;
        private final List<Connection> knownConnections = new ArrayList<Connection>();

        JDBCConnectorAsDataSource(String databaseName, AuditLog auditLog) {
            this.databaseName = databaseName;
            this.auditLog = auditLog;
        }

        @Override
        public Connection getConnection() throws SQLException {
            String methodName = "dataSource.getConnection";
            try {
                Connection jdbcConnection = JDBCResourceConnector.this.connectionProperties.getUserId() == null || JDBCResourceConnector.this.connectionProperties.getClearPassword() == null ? DriverManager.getConnection(JDBCResourceConnector.this.connectionProperties.getEndpoint().getAddress()) : DriverManager.getConnection(JDBCResourceConnector.this.connectionProperties.getEndpoint().getAddress(), JDBCResourceConnector.this.connectionBean.getUserId(), JDBCResourceConnector.this.connectionBean.getClearPassword());
                if (jdbcConnection != null) {
                    this.knownConnections.add(jdbcConnection);
                }
                if (this.auditLog != null) {
                    this.auditLog.logMessage("dataSource.getConnection", JDBCAuditCode.CONNECTOR_CONNECTED_TO_DATABASE.getMessageDefinition(this.databaseName));
                }
                return jdbcConnection;
            }
            catch (SQLException error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("dataSource.getConnection", JDBCAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.databaseName, error.getClass().getName(), "dataSource.getConnection", error.getMessage()), (Throwable)error);
                }
                throw error;
            }
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            String methodName = "dataSource.getConnection(supplied security)";
            try {
                Connection jdbcConnection = DriverManager.getConnection(JDBCResourceConnector.this.connectionBean.getEndpoint().getAddress(), username, password);
                if (this.auditLog != null) {
                    this.auditLog.logMessage("dataSource.getConnection(supplied security)", JDBCAuditCode.CONNECTOR_CONNECTED_TO_DATABASE.getMessageDefinition(this.databaseName));
                }
                return jdbcConnection;
            }
            catch (SQLException error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("dataSource.getConnection(supplied security)", JDBCAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.databaseName, error.getClass().getName(), "dataSource.getConnection(supplied security)", error.getMessage()), (Throwable)error);
                }
                throw error;
            }
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return DriverManager.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            DriverManager.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            DriverManager.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return DriverManager.getLoginTimeout();
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public <T> T unwrap(Class<T> requestedInterface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> requestedInterface) throws SQLException {
            return false;
        }

        public void disconnect() {
            String methodName = "disconnect";
            if (this.auditLog != null) {
                String numberOfConnections = "zero";
                if (!this.knownConnections.isEmpty()) {
                    numberOfConnections = Integer.toString(this.knownConnections.size());
                }
                this.auditLog.logMessage("disconnect", JDBCAuditCode.CONNECTOR_STOPPING.getMessageDefinition(JDBCResourceConnector.this.jdbcDatabaseName, numberOfConnections));
            }
            for (Connection connection : this.knownConnections) {
                try {
                    if (connection.isClosed()) continue;
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

