/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.resource.jdbc.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.controls.ConfigurationPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;

public enum JDBCConfigurationProperty {
    DATABASE_URL("databaseURL", "Connection string for the database where the schema is located. This should set the current schema to your chosen schema.", DataType.STRING.getName(), "~{postgreSQLDatabaseURL}~"),
    DATABASE_NAME("databaseName", "Provides a name to use in messages about the database.  If it is not set then the connection URL string is used.", DataType.STRING.getName(), null),
    DATABASE_SCHEMA("databaseSchema", "The name of the database schema used to store the data.  This should match the schema set up in the database URL.", DataType.STRING.getName(), null),
    SECRETS_STORE("secretsStore", "The file name of the secrets store containing the log on credentials to access the database.", DataType.STRING.getName(), "~{secretsStore}~"),
    SECRETS_COLLECTION_NAME("secretsCollectionName", "The name of the secrets collection within the secrets store to use for login credentials.", DataType.STRING.getName(), "~{postgreSQLServerCollectionName}~"),
    JDBC_DRIVER_MANAGER_CLASS_NAME("jdbcDriverManagerClassName", "An optional configuration property that causes the named class to be loaded and registered as a driver. This property only needs to be defined if the connector is experiencing exceptions related to a missing DriverManager class for the database URL.", DataType.STRING.getName(), null),
    JDBC_CONNECTION_TIMEOUT("jdbcConnectionTimeout", "Sets the maximum time in seconds that this data source will wait while attempting to connect to a database. The default value is 0 which means use the system default timeout, if any; otherwise it means no timeout.", DataType.INT.getName(), "10");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private JDBCConfigurationProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<String> getRecognizedConfigurationProperties() {
        ArrayList<String> recognizedConfigurationProperties = new ArrayList<String>();
        for (JDBCConfigurationProperty configurationProperty : JDBCConfigurationProperty.values()) {
            recognizedConfigurationProperties.add(configurationProperty.getName());
        }
        return recognizedConfigurationProperties;
    }

    public static List<ConfigurationPropertyType> getConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        for (JDBCConfigurationProperty configurationProperty : JDBCConfigurationProperty.values()) {
            configurationPropertyTypes.add(configurationProperty.getConfigurationPropertyType());
        }
        return configurationPropertyTypes;
    }

    public ConfigurationPropertyType getConfigurationPropertyType() {
        ConfigurationPropertyType requestParameterType = new ConfigurationPropertyType();
        requestParameterType.setName(this.name);
        requestParameterType.setDescription(this.description);
        requestParameterType.setDataType(this.dataType);
        requestParameterType.setExample(this.example);
        return requestParameterType;
    }

    public String toString() {
        return "MoveCopyFileRequestParameter{ name=" + this.name + "}";
    }
}

