/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLColumn;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLForeignKey;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLTable;

public class PostgreSQLSchemaDDL {
    private final String schemaName;
    private final String schemaDescription;
    private final List<PostgreSQLTable> tables;

    public PostgreSQLSchemaDDL(String schemaName, String schemaDescription, List<PostgreSQLTable> tables) {
        this.schemaName = schemaName;
        this.schemaDescription = schemaDescription;
        this.tables = tables;
    }

    public List<String> getDDLStatements() {
        ArrayList<String> ddlStatements = new ArrayList<String>();
        ddlStatements.add("create schema if not exists " + this.schemaName + ";");
        if (this.schemaDescription != null) {
            ddlStatements.add(this.getComment("schema", this.schemaName, this.schemaDescription));
        }
        if (this.tables != null) {
            for (PostgreSQLTable table : this.tables) {
                if (table == null) continue;
                ddlStatements.add("create table if not exists " + table.getTableName() + "(" + this.getColumnsDDL(table.getTableName(), table.getPrimaryKeys(), table.getDataColumns(), table.getForeignKeys()) + ");");
                if (table.getTableDescription() != null) {
                    ddlStatements.add(this.getComment("table", table.getTableName(), table.getTableDescription()));
                }
                ddlStatements.addAll(this.getColumnCommentStatements(table.getTableName(), table.getPrimaryKeys()));
                ddlStatements.addAll(this.getColumnCommentStatements(table.getTableName(), table.getDataColumns()));
            }
        }
        return ddlStatements;
    }

    private String getColumnsDDL(String tableName, List<PostgreSQLColumn> primaryKeys, List<PostgreSQLColumn> dataColumns, List<PostgreSQLForeignKey> foreignKeys) {
        boolean firstColumn;
        String columnDefinitions;
        HashMap<String, PostgreSQLForeignKey> foreignKeyMap = new HashMap<String, PostgreSQLForeignKey>();
        if (foreignKeys != null) {
            for (PostgreSQLForeignKey foreignKey : foreignKeys) {
                if (foreignKey == null) continue;
                foreignKeyMap.put(foreignKey.getForeignKeyColumn().getColumnName(), foreignKey);
            }
        }
        if (!(columnDefinitions = this.getColumnsDDL(primaryKeys, foreignKeyMap, firstColumn = true)).isBlank()) {
            firstColumn = false;
        }
        return columnDefinitions + this.getColumnsDDL(dataColumns, foreignKeyMap, firstColumn) + this.addPrimaryKeysConstraint(tableName, primaryKeys);
    }

    private String getColumnsDDL(List<PostgreSQLColumn> columns, Map<String, PostgreSQLForeignKey> foreignKeyMap, boolean firstColumn) {
        if (columns != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (PostgreSQLColumn column : columns) {
                if (column == null) continue;
                if (firstColumn) {
                    firstColumn = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(column.getColumnName());
                stringBuilder.append(" ");
                stringBuilder.append(column.getColumnType().getPostgresType());
                if (column.isNotNull()) {
                    stringBuilder.append(" not null");
                }
                if (foreignKeyMap.get(column.getColumnName()) == null) continue;
                PostgreSQLForeignKey foreignKey = foreignKeyMap.get(column.getColumnName());
                stringBuilder.append(" constraint ");
                stringBuilder.append(foreignKey.getConstraintName());
                stringBuilder.append(" references ");
                stringBuilder.append(foreignKey.getReferenceTable().getTableName());
                stringBuilder.append(" on update ");
                if (foreignKey.isUpdateCascade()) {
                    stringBuilder.append("cascade");
                } else {
                    stringBuilder.append("no action");
                }
                stringBuilder.append(" on delete ");
                if (foreignKey.isDeleteCascade()) {
                    stringBuilder.append("cascade");
                    continue;
                }
                stringBuilder.append("no action");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private String addPrimaryKeysConstraint(String tableName, List<PostgreSQLColumn> primaryKeys) {
        if (primaryKeys != null) {
            StringBuilder stringBuilder = new StringBuilder(", constraint " + tableName + "_pk primary key (");
            boolean firstPrimaryKey = true;
            for (PostgreSQLColumn primaryKey : primaryKeys) {
                if (primaryKey == null) continue;
                if (firstPrimaryKey) {
                    firstPrimaryKey = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(primaryKey.getColumnName());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return "";
    }

    private List<String> getColumnCommentStatements(String tableName, List<PostgreSQLColumn> columns) {
        ArrayList<String> ddlStatements = new ArrayList<String>();
        if (columns != null) {
            for (PostgreSQLColumn column : columns) {
                if (column == null || column.getColumnDescription() == null) continue;
                ddlStatements.add(this.getComment("column", tableName + "." + column.getColumnName(), column.getColumnDescription()));
            }
        }
        return ddlStatements;
    }

    private String getComment(String definitionType, String definitionName, String definitionDescription) {
        if (definitionDescription != null) {
            String[] descriptionParts = definitionDescription.split("'");
            StringBuilder stringBuilder = new StringBuilder("comment on ");
            stringBuilder.append(definitionType);
            stringBuilder.append(" ");
            stringBuilder.append(definitionName);
            stringBuilder.append(" is '");
            if (descriptionParts.length == 1) {
                stringBuilder.append(definitionDescription);
            } else {
                int index;
                for (index = 0; index < descriptionParts.length - 1; ++index) {
                    stringBuilder.append(descriptionParts[index]);
                    stringBuilder.append("''");
                }
                stringBuilder.append(descriptionParts[index]);
            }
            stringBuilder.append("';");
            return stringBuilder.toString();
        }
        return "";
    }
}

