/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.resource.jdbc.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum JDBCAuditCode implements AuditLogMessageSet
{
    UNEXPECTED_EXCEPTION("JDBC-RESOURCE-CONNECTOR-0001", AuditLogRecordSeverityLevel.EXCEPTION, "The JDBC resource connector for database {0} received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to process the current request.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    CONNECTOR_CONNECTED_TO_DATABASE("JDBC-RESOURCE-CONNECTOR-0002", AuditLogRecordSeverityLevel.INFO, "The JDBC resource connector has connected to database {0}", "The connector is designed provide a standard interface to a relational database that supports Java Database Connectivity (JDBC).  This message confirms that the connector has successfully connected to the database.  The number of times that this message is emitted by a connector indicates how many database connections it is using.", "No specific action is required.  This message is to confirm that the configuration of the connector is sufficient to connect to the database."),
    UNEXPECTED_ROW_COUNT_FROM_DATABASE("JDBC-RESOURCE-CONNECTOR-0003", AuditLogRecordSeverityLevel.INFO, "The JDBC resource connector for database {0} has received {1} results from query {2}", "The connector is designed provide a standard interface to a relational database that supports Java Database Connectivity (JDBC).  This message confirms that the connector has successfully connected to the database.  The number of times that this message is emitted by a connector indicates how many database connections it is using.", "No specific action is required.  This message is to confirm that the configuration of the connector is sufficient to connect to the database."),
    CONNECTOR_STOPPING("JDBC-RESOURCE-CONNECTOR-0009", AuditLogRecordSeverityLevel.INFO, "The JDBC resource connector for database {0} is closing all {1} connection(s) to database and is shutting down", "The connector has been requested to disconnect from the database and is ensuring all connections are closed.  This message is output by each data source that was created by the connector.  Therefore the number of times that this message is emitted indicates the number of data sources were created by the connector.", "No action is required unless there are errors that follow indicating that there were problems shutting down.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private JDBCAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "JDBCAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

