/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.resource.jdbc.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum JDBCErrorCode implements ExceptionMessageSet
{
    NULL_URL(400, "JDBC-RESOURCE-CONNECTOR-400-001", "Connection {0} has been configured without the URL to the database", "The connector is unable to start because the endpoint of its connection has a null address property.", "Update the connection's endpoint to include the connection string needed to connect to the desired database."),
    BAD_DRIVER_MANAGER_CLASS(400, "JDBC-RESOURCE-CONNECTOR-400-002", "The JDBC resource connector for database {0} has been configured with an invalid DriverManager class name of {1} in its connection {2}: ClassNotFoundException message is {3}", "The connector fails to start.", "Update the 'jdbcDriverManagerClassName' configuration property in this connector's connection.  This property is only needed for unusual databases.  It may also be worth trying the connector without this property to see if the driver is well known to your JDBC implementation."),
    UNEXPECTED_EXCEPTION(500, "JDBC-RESOURCE-CONNECTOR-500-001", "The JDBC resource connector for database {0} received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to process the current request.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    MISSING_DATABASE_VALUE(500, "JDBC-RESOURCE-CONNECTOR-500-002", "The JDBC resource connector detected a missing value for column {0} during method {1} in mapper {2}", "The connector is unable to process the current request because of a missing value in the database.", "Investigate the contents of the database and the SQL requests used to populate it."),
    UNEXPECTED_SQL_EXCEPTION(500, "JDBC-RESOURCE-CONNECTOR-500-003", "The JDBC resource connector for database {0} received an unexpected SQL exception from request \"{1}\" during method {2}; the error message was: {3}", "The connector is unable to process the current request because the database returned an unexpected error.", "Use the details from the SQL error message and the SQL request to determine the cause of the error and retry the request once it is resolved.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private JDBCErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

