/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.resource.jdbc.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ffdc.JDBCErrorCode;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.ColumnType;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.JDBCDataValue;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class BaseMapper {
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writer();
    private static final ObjectReader OBJECT_READER = new ObjectMapper().reader();
    private final String connectorName;

    public BaseMapper(String connectorName) {
        this.connectorName = connectorName;
    }

    public String getStringPropertyFromColumn(String columnName, Map<String, JDBCDataValue> instanceTableRow, boolean isRequired) throws RepositoryErrorException {
        String methodName = "getStringPropertyFromColumn";
        if (instanceTableRow == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getStringPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getStringPropertyFromColumn");
        }
        JDBCDataValue jdbcDataValue = instanceTableRow.get(columnName);
        String newValue = null;
        if (jdbcDataValue != null && jdbcDataValue.getDataValue() != null) {
            newValue = jdbcDataValue.getDataValue().toString();
        }
        if (isRequired && newValue == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getStringPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getStringPropertyFromColumn");
        }
        return newValue;
    }

    public List<String> getStringArrayPropertyFromColumn(String columnName, Map<String, JDBCDataValue> instanceTableRow, boolean isRequired) throws RepositoryErrorException {
        String methodName = "getStringArrayPropertyFromColumn";
        if (instanceTableRow == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getStringArrayPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getStringArrayPropertyFromColumn");
        }
        JDBCDataValue jdbcDataValue = instanceTableRow.get(columnName);
        String newValue = null;
        if (jdbcDataValue != null && jdbcDataValue.getDataValue() != null) {
            newValue = jdbcDataValue.getDataValue().toString();
        }
        if (isRequired && newValue == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getStringArrayPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getStringArrayPropertyFromColumn");
        }
        if (newValue == null) {
            return null;
        }
        return Arrays.asList(newValue.split(","));
    }

    public Map<String, Serializable> getSerializableMapPropertyFromColumn(String columnName, Map<String, JDBCDataValue> instanceTableRow, boolean isRequired) throws RepositoryErrorException {
        String methodName = "getSerializableMapPropertyFromColumn";
        if (instanceTableRow == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getSerializableMapPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getSerializableMapPropertyFromColumn");
        }
        JDBCDataValue jdbcDataValue = instanceTableRow.get(columnName);
        String newValue = null;
        if (jdbcDataValue != null && jdbcDataValue.getDataValue() != null) {
            newValue = jdbcDataValue.getDataValue().toString();
        }
        if (isRequired && newValue == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getSerializableMapPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getSerializableMapPropertyFromColumn");
        }
        if (newValue != null) {
            try {
                SerializableMap serializableMap = (SerializableMap)OBJECT_READER.readValue(newValue, SerializableMap.class);
                if (serializableMap != null) {
                    return serializableMap.getMappingProperties();
                }
            }
            catch (Exception error) {
                throw new RepositoryErrorException(JDBCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "getSerializableMapPropertyFromColumn", error.getMessage()), error.getClass().getName(), "getSerializableMapPropertyFromColumn", (Throwable)error);
            }
        }
        return null;
    }

    public Date getDatePropertyFromColumn(String columnName, Map<String, JDBCDataValue> instanceTableRow, boolean isRequired) throws RepositoryErrorException {
        Object object;
        String methodName = "getDatePropertyFromColumn";
        if (instanceTableRow == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getDatePropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getDatePropertyFromColumn");
        }
        JDBCDataValue jdbcDataValue = instanceTableRow.get(columnName);
        Date newValue = null;
        if (jdbcDataValue != null && (object = jdbcDataValue.getDataValue()) instanceof Long) {
            Long longValue = (Long)object;
            newValue = new Date(longValue);
        }
        if (jdbcDataValue != null && (object = jdbcDataValue.getDataValue()) instanceof Date) {
            Date dateValue;
            newValue = dateValue = (Date)object;
        }
        if (isRequired && newValue == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getDatePropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getDatePropertyFromColumn");
        }
        return newValue;
    }

    public long getLongPropertyFromColumn(String columnName, Map<String, JDBCDataValue> instanceTableRow, boolean isRequired) throws RepositoryErrorException {
        Object object;
        String methodName = "getLongPropertyFromColumn";
        if (instanceTableRow == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getLongPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getLongPropertyFromColumn");
        }
        JDBCDataValue jdbcDataValue = instanceTableRow.get(columnName);
        if (jdbcDataValue != null && (object = jdbcDataValue.getDataValue()) instanceof Long) {
            Long longValue = (Long)object;
            return longValue;
        }
        if (jdbcDataValue != null && (object = jdbcDataValue.getDataValue()) instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)object;
            return bigDecimalValue.longValue();
        }
        if (isRequired) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getLongPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getLongPropertyFromColumn");
        }
        return 0L;
    }

    public boolean getBooleanPropertyFromColumn(String columnName, Map<String, JDBCDataValue> instanceTableRow, boolean isRequired) throws RepositoryErrorException {
        Object object;
        String methodName = "getBooleanPropertyFromColumn";
        if (instanceTableRow == null) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getBooleanPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getBooleanPropertyFromColumn");
        }
        JDBCDataValue jdbcDataValue = instanceTableRow.get(columnName);
        if (jdbcDataValue != null && (object = jdbcDataValue.getDataValue()) instanceof Boolean) {
            Boolean booleanValue = (Boolean)object;
            return booleanValue;
        }
        if (isRequired) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "getBooleanPropertyFromColumn", this.getClass().getName()), this.getClass().getName(), "getBooleanPropertyFromColumn");
        }
        return false;
    }

    protected void setUpStringValueInRow(Map<String, JDBCDataValue> instanceTableRow, String propertyValue, String columnName, boolean isRequired) throws RepositoryErrorException {
        String methodName = "setUpStringValueInRow";
        if (propertyValue == null && isRequired) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "setUpStringValueInRow", this.getClass().getName()), this.getClass().getName(), "setUpStringValueInRow");
        }
        if (propertyValue != null) {
            instanceTableRow.put(columnName, new JDBCDataValue(propertyValue, ColumnType.STRING.getJdbcType()));
        }
    }

    protected void setUpStringArrayValueInRow(Map<String, JDBCDataValue> instanceTableRow, List<String> propertyValues, String columnName, boolean isRequired) throws RepositoryErrorException {
        String methodName = "setUpStringArrayValueInRow";
        if (propertyValues == null && isRequired) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "setUpStringArrayValueInRow", this.getClass().getName()), this.getClass().getName(), "setUpStringArrayValueInRow");
        }
        StringBuilder propertyValueAsString = new StringBuilder();
        boolean firstProperty = true;
        if (propertyValues != null) {
            for (String propertyValue : propertyValues) {
                if (propertyValue == null) continue;
                if (firstProperty) {
                    firstProperty = false;
                } else {
                    propertyValueAsString.append(",");
                }
                propertyValueAsString.append(propertyValue);
            }
            instanceTableRow.put(columnName, new JDBCDataValue(propertyValueAsString.toString(), ColumnType.STRING.getJdbcType()));
        }
    }

    protected void setUpSerializableMapValueInRow(Map<String, JDBCDataValue> instanceTableRow, Map<String, Serializable> propertyValues, String columnName, boolean isRequired) throws RepositoryErrorException {
        String methodName = "setUpStringArrayValueInRow";
        if (propertyValues == null && isRequired) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "setUpStringArrayValueInRow", this.getClass().getName()), this.getClass().getName(), "setUpStringArrayValueInRow");
        }
        if (propertyValues != null) {
            try {
                SerializableMap serializableMap = new SerializableMap();
                serializableMap.setMappingProperties(propertyValues);
                instanceTableRow.put(columnName, new JDBCDataValue(OBJECT_WRITER.writeValueAsString((Object)serializableMap), ColumnType.STRING.getJdbcType()));
            }
            catch (Exception error) {
                throw new RepositoryErrorException(JDBCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "setUpStringArrayValueInRow", error.getMessage()), error.getClass().getName(), "setUpStringArrayValueInRow", (Throwable)error);
            }
        }
    }

    protected void setUpDateValueInRow(Map<String, JDBCDataValue> instanceTableRow, Date propertyValue, String columnName, boolean isRequired) throws RepositoryErrorException {
        String methodName = "setUpDateValueInRow";
        if (propertyValue == null && isRequired) {
            throw new RepositoryErrorException(JDBCErrorCode.MISSING_DATABASE_VALUE.getMessageDefinition(columnName, "setUpDateValueInRow", this.getClass().getName()), this.getClass().getName(), "setUpDateValueInRow");
        }
        if (propertyValue != null) {
            instanceTableRow.put(columnName, new JDBCDataValue(propertyValue, ColumnType.DATE.getJdbcType()));
        }
    }

    protected void setUpBooleanValueInRow(Map<String, JDBCDataValue> instanceTableRow, boolean propertyValue, String columnName) {
        instanceTableRow.put(columnName, new JDBCDataValue(propertyValue, ColumnType.BOOLEAN.getJdbcType()));
    }

    protected void setUpLongValueInRow(Map<String, JDBCDataValue> instanceTableRow, long propertyValue, String columnName) {
        instanceTableRow.put(columnName, new JDBCDataValue(propertyValue, ColumnType.LONG.getJdbcType()));
    }

    static class SerializableMap {
        private Map<String, Serializable> mappingProperties = null;

        SerializableMap() {
        }

        public Map<String, Serializable> getMappingProperties() {
            return this.mappingProperties;
        }

        public void setMappingProperties(Map<String, Serializable> mappingProperties) {
            this.mappingProperties = mappingProperties;
        }
    }
}

