/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.integration.controls.CatalogTargetType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;

public enum DistributeAuditEventCatalogTarget {
    INCOMING_TOPIC("kafkaTopicToMonitor", DeployedImplementationType.APACHE_KAFKA_TOPIC.getAssociatedTypeName(), DeployedImplementationType.APACHE_KAFKA_TOPIC.getDeployedImplementationType(), null),
    DESTINATION("auditLogDestination", DeployedImplementationType.DATA_ASSET.getAssociatedTypeName(), DeployedImplementationType.DATA_ASSET.getDeployedImplementationType(), null);

    private final String name;
    private final String typeName;
    private final String deployedImplementationType;
    private final Map<String, String> otherPropertyValues;

    private DistributeAuditEventCatalogTarget(String name, String typeName, String deployedImplementationType, Map<String, String> otherPropertyValues) {
        this.name = name;
        this.typeName = typeName;
        this.deployedImplementationType = deployedImplementationType;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<CatalogTargetType> getCatalogTargetTypes() {
        ArrayList<CatalogTargetType> catalogTargetTypes = new ArrayList<CatalogTargetType>();
        for (DistributeAuditEventCatalogTarget catalogTarget : DistributeAuditEventCatalogTarget.values()) {
            catalogTargetTypes.add(catalogTarget.getCatalogTargetType());
        }
        return catalogTargetTypes;
    }

    public CatalogTargetType getCatalogTargetType() {
        CatalogTargetType catalogTargetType = new CatalogTargetType();
        catalogTargetType.setName(this.name);
        catalogTargetType.setTypeName(this.typeName);
        catalogTargetType.setDeployedImplementationType(this.deployedImplementationType);
        catalogTargetType.setOtherPropertyValues(this.otherPropertyValues);
        return catalogTargetType;
    }

    public String toString() {
        return "CatalogTargetEnum{catalogTargetName='" + this.name + "'}";
    }
}

