/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DistributeKafkaErrorCode implements ExceptionMessageSet
{
    NULL_TOPIC(400, "DISTRIBUTE-KAFKA-AUDIT-LOG-400-001", "Integration connector {0} has been configured without any topics to listen on", "The connector is move to FAILED status and will not be called by the integration daemon until the configuration error has been corrected.", "Add at least one embedded connection for a topic that is distributing audit log events."),
    NULL_DESTINATION(400, "DISTRIBUTE-KAFKA-AUDIT-LOG-400-002", "Integration connector {0} has been configured without any audit log destination to write to", "The connector is move to FAILED status and will not be called by the integration daemon until the configuration has been added to this connector.", "Add at least one embedded connection for an audit log destination connector that is where the audit log events should be sent to."),
    UNEXPECTED_EXCEPTION(500, "DISTRIBUTE-KAFKA-AUDIT-LOG-500-001", "The {0} integration connector received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to catalog one or more metadata elements.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private DistributeKafkaErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

