/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit;

import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFolderConnector;
import org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit.ffdc.DistributeKafkaAuditCode;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.console.ConsoleAuditLogStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.file.FileBasedAuditLogStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.postgres.PostgreSQLAuditLogDestinationProvider;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetProcessorBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStoreConnectorBase;

public class AuditLogDestinationCatalogTargetProcessor
extends CatalogTargetProcessorBase {
    private OMRSAuditLogStoreConnectorBase auditLogDestination = null;

    public AuditLogDestinationCatalogTargetProcessor(CatalogTarget template, Connector connectorToTarget, String connectorName, AuditLog auditLog) {
        super(template, connectorToTarget, connectorName, auditLog);
        String methodName = "AuditLogDestinationCatalogTargetProcessor constructor";
        ConnectionDetails auditLogConnection = connectorToTarget instanceof JDBCResourceConnector ? this.getAuditLogConnection(connectorToTarget, new PostgreSQLAuditLogDestinationProvider().getConnectorType()) : (connectorToTarget instanceof BasicFolderConnector ? this.getAuditLogConnection(connectorToTarget, new FileBasedAuditLogStoreProvider().getConnectorType()) : this.getAuditLogConnection(connectorToTarget, new ConsoleAuditLogStoreProvider().getConnectorType()));
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker(auditLog);
            this.auditLogDestination = (OMRSAuditLogStoreConnectorBase)connectorBroker.getConnector(auditLogConnection);
        }
        catch (Exception error) {
            auditLog.logMessage("AuditLogDestinationCatalogTargetProcessor constructor", DistributeKafkaAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(connectorName, error.getClass().getName(), "AuditLogDestinationCatalogTargetProcessor constructor", error.getMessage()));
        }
    }

    private ConnectionDetails getAuditLogConnection(Connector assetConnector, ConnectorType auditLogConnectorType) {
        return new ConnectionDetails(assetConnector.getConnection(), auditLogConnectorType);
    }

    public void storeLogRecord(OMRSAuditLogRecord logRecord) {
        String methodName = "storeLogRecord";
        if (this.auditLogDestination != null) {
            try {
                this.auditLogDestination.storeLogRecord(logRecord);
            }
            catch (Exception error) {
                this.auditLog.logException("storeLogRecord", DistributeKafkaAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
    }

    public void refresh() {
    }
}

