/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit.AuditLogDestinationCatalogTargetProcessor;
import org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit.KafkaTopicSourceCatalogTargetProcessor;
import org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit.controls.DistributeAuditEventCatalogTarget;
import org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit.ffdc.DistributeKafkaAuditCode;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;

public class DistributeAuditEventsFromKafkaConnector
extends CatalogIntegratorConnector
implements OpenMetadataTopicListener,
CatalogTargetIntegrator {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public void refresh() throws ConnectorCheckedException {
        super.refreshCatalogTargets((CatalogTargetIntegrator)this);
    }

    public void processEvent(String event) {
        String methodName = "processEvent";
        if (event != null) {
            try {
                OMRSAuditLogRecord eventObject = (OMRSAuditLogRecord)OBJECT_MAPPER.readValue(event, OMRSAuditLogRecord.class);
                for (RequestedCatalogTarget requestedCatalogTarget : this.catalogTargetsManager.getRequestedCatalogTargets()) {
                    if (!(requestedCatalogTarget instanceof AuditLogDestinationCatalogTargetProcessor)) continue;
                    AuditLogDestinationCatalogTargetProcessor auditLogDestination = (AuditLogDestinationCatalogTargetProcessor)requestedCatalogTarget;
                    auditLogDestination.storeLogRecord(eventObject);
                }
            }
            catch (Exception error) {
                this.auditLog.logException("processEvent", DistributeKafkaAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
    }

    public void integrateCatalogTarget(RequestedCatalogTarget requestedCatalogTarget) throws ConnectorCheckedException {
    }

    public RequestedCatalogTarget getNewRequestedCatalogTargetSkeleton(CatalogTarget retrievedCatalogTarget, Connector connectorToTarget) throws ConnectorCheckedException {
        if (DistributeAuditEventCatalogTarget.INCOMING_TOPIC.getName().equals(retrievedCatalogTarget.getCatalogTargetName())) {
            if (this.propertyHelper.isTypeOf((ElementControlHeader)retrievedCatalogTarget.getCatalogTargetElement(), OpenMetadataType.KAFKA_TOPIC.typeName)) {
                return new KafkaTopicSourceCatalogTargetProcessor(retrievedCatalogTarget, connectorToTarget, this.connectorName, this.auditLog, this);
            }
        } else if (DistributeAuditEventCatalogTarget.DESTINATION.getName().equals(retrievedCatalogTarget.getCatalogTargetName()) && this.propertyHelper.isTypeOf((ElementControlHeader)retrievedCatalogTarget.getCatalogTargetElement(), OpenMetadataType.DATA_ASSET.typeName)) {
            return new AuditLogDestinationCatalogTargetProcessor(retrievedCatalogTarget, connectorToTarget, this.connectorName, this.auditLog);
        }
        return new RequestedCatalogTarget(retrievedCatalogTarget, connectorToTarget);
    }
}

