/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.eventbus.topic.kafka;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KafkaOpenMetadataTopicConnectorAuditCode {
    SERVICE_INITIALIZING("OCF-KAFKA-TOPIC-CONNECTOR-0001", OMRSAuditLogRecordSeverity.INFO, "Connecting to Apache Kafka Topic {0} with a server identifier of {1}", "The local server has started up the Apache Kafka connector.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_PRODUCER_PROPERTIES("OCF-KAFKA-TOPIC-CONNECTOR-0002", OMRSAuditLogRecordSeverity.INFO, "The properties passed to the Apache Kafka Producer are: {0}", "The server is registering to receive events from Apache Kafka using the properties shown.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_CONSUMER_PROPERTIES("OCF-KAFKA-TOPIC-CONNECTOR-0003", OMRSAuditLogRecordSeverity.INFO, "The properties passed to the Apache Kafka Consumer are: {0}", "The server is registering to receive events from Apache Kafka using the properties shown.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_SHUTDOWN("OCF-KAFKA-TOPIC-CONNECTOR-004", OMRSAuditLogRecordSeverity.INFO, "The Apache Kafka connector for topic {0} is shutting down", "The local server has requested shut down of the Apache Kafka connector.", "No action is required.  This is part of the normal operation of the server."),
    NULL_ADDITIONAL_PROPERTIES("OCF-KAFKA-TOPIC-CONNECTOR-0005", OMRSAuditLogRecordSeverity.ERROR, "The Apache Kafka connector for topic {0} has been set up with no additional properties", "Without these properties, the server is not able to send and receive events on the topic.", "This problem must be fixed before the server can exchange metadata.  The properties are supplied on the event bus admin command."),
    UNABLE_TO_PARSE_ADDITIONAL_PROPERTIES("OCF-KAFKA-TOPIC-CONNECTOR-0006", OMRSAuditLogRecordSeverity.ERROR, "The Apache Kafka connector for topic {0} has been set up with additional properties that produced the {1} exception when read.  This is the error message: {2}", "An exception occurred reading the additional properties.  This means that the server is not able to send and receive events on the topic.", "This problem must be fixed before the server can exchange metadata.  The properties are supplied on the event bus admin command."),
    NO_TOPIC_NAME("OCF-KAFKA-TOPIC-CONNECTOR-0007", OMRSAuditLogRecordSeverity.ERROR, "The Apache Kafka connector has been set up with no topic name", "Without the name of the topic, the server is not able to send and receive events.", "This problem must be fixed before the server can exchange metadata.  The topic name is supplied in the endpoint object of the connector's connection."),
    EXCEPTION_RECEIVING_EVENT("OCF-KAFKA-TOPIC-CONNECTOR-0008", OMRSAuditLogRecordSeverity.ERROR, "The connector listening on topic {0} received an unexpected exception {1} from Apache Kafka.  The message in the exception was {2}", "A call to receive events from Apache Kafka failed with an exception.", "Use the information in the event and the exception message, along with other messages to determine the source of the error."),
    EXCEPTION_DISTRIBUTING_EVENT("OCF-KAFKA-TOPIC-CONNECTOR-0009", OMRSAuditLogRecordSeverity.ERROR, "The Apache Kafka connector listening on topic {0} received an unexpected exception {1} distributing an event to components within the server.  The event was {2} and the message in the exception was {3}", "An incoming event could not be processed by one or more components in the server.", "Use the information in the event and the exception message, along with other messages to determine the source of the error.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private KafkaOpenMetadataTopicConnectorAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("<== Kafka Connector Audit Code.getMessage(%s)", Arrays.toString(params)));
        }
        MessageFormat mf = new MessageFormat(this.logMessage);
        String result = mf.format(params);
        if (log.isDebugEnabled()) {
            log.debug(String.format("==> Kafka Connector Audit Code.getMessage(%s): %s", Arrays.toString(params), result));
        }
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(KafkaOpenMetadataTopicConnectorAuditCode.class);
    }
}

