/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.eventbus.topic.kafka;

import java.util.Properties;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataEventConsumerProperty;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConnectorErrorException;

public class KafkaOpenMetadataEventConsumerConfiguration {
    private final Properties properties;

    public KafkaOpenMetadataEventConsumerConfiguration(Properties properties) {
        this.properties = properties;
    }

    public int getIntProperty(KafkaOpenMetadataEventConsumerProperty property) {
        return Integer.parseInt(this.getProperty(property));
    }

    public long getLongProperty(KafkaOpenMetadataEventConsumerProperty property) {
        return Long.parseLong(this.getProperty(property));
    }

    public String getProperty(KafkaOpenMetadataEventConsumerProperty property) {
        String value = this.properties.getProperty(property.getPropertyName(), property.getDefaultValue());
        if (value == null || value.trim().length() == 0) {
            OMRSErrorCode errorCode = OMRSErrorCode.LOCAL_REPOSITORY_CONFIGURATION_ERROR;
            String errorMessage = "The required connector property " + property.getPropertyName() + " is not set";
            throw new OMRSConnectorErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "Please add the property " + property.getPropertyName() + " the connector configuration", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return value;
    }
}

