/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.eventbus.topic.kafka;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataEventConsumer;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataEventConsumerConfiguration;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataEventProducer;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AdditionalProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOpenMetadataTopicConnector
extends OpenMetadataTopicConnector {
    private static final Logger log = LoggerFactory.getLogger(KafkaOpenMetadataTopicConnector.class);
    private Properties producerProperties = new Properties();
    private Properties consumerEgeriaProperties = new Properties();
    private Properties consumerProperties = new Properties();
    private KafkaOpenMetadataEventConsumer consumer = null;
    private KafkaOpenMetadataEventProducer producer = null;
    private String topicName = null;
    private String serverId = null;
    private List<String> incomingEventsList = Collections.synchronizedList(new ArrayList());

    public KafkaOpenMetadataTopicConnector() {
        this.producerProperties.put("bootstrap.servers", "localhost:9092");
        this.producerProperties.put("acks", "all");
        this.producerProperties.put("retries", (Object)1);
        this.producerProperties.put("batch.size", (Object)16384);
        this.producerProperties.put("linger.ms", (Object)0);
        this.producerProperties.put("buffer.memory", (Object)0x2000000);
        this.producerProperties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producerProperties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.consumerProperties.put("bootstrap.servers", "localhost:9092");
        this.consumerProperties.put("enable.auto.commit", "true");
        this.consumerProperties.put("auto.commit.interval.ms", "1000");
        this.consumerProperties.put("session.timeout.ms", "30000");
        this.consumerProperties.put("max.partition.fetch.bytes", (Object)0xA00000);
        this.consumerProperties.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.consumerProperties.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
    }

    private void initializeTopic() {
        String actionDescription = "initialize";
        super.initialize(this.connectorInstanceId, this.connectionProperties);
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.topicName = endpoint.getAddress();
            AdditionalProperties additionalProperties = this.connectionProperties.getAdditionalProperties();
            if (additionalProperties != null) {
                this.initializeKafkaProperties(additionalProperties);
                this.serverId = (String)additionalProperties.getProperty("local.server.id");
                this.consumerProperties.put("group.id", this.serverId);
                if (this.auditLog != null) {
                    KafkaOpenMetadataTopicConnectorAuditCode auditCode = KafkaOpenMetadataTopicConnectorAuditCode.SERVICE_INITIALIZING;
                    this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.topicName, this.serverId), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            } else if (this.auditLog != null) {
                KafkaOpenMetadataTopicConnectorAuditCode auditCode = KafkaOpenMetadataTopicConnectorAuditCode.NULL_ADDITIONAL_PROPERTIES;
                this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.topicName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        } else if (this.auditLog != null) {
            KafkaOpenMetadataTopicConnectorAuditCode auditCode = KafkaOpenMetadataTopicConnectorAuditCode.NO_TOPIC_NAME;
            this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void initializeKafkaProperties(AdditionalProperties additionalProperties) {
        String actionDescription = "initializeKafkaProperties";
        try {
            Object propertiesObject = additionalProperties.getProperty("producer");
            this.copyProperties(propertiesObject, this.producerProperties);
            propertiesObject = additionalProperties.getProperty("consumer");
            this.copyProperties(propertiesObject, this.consumerProperties);
            propertiesObject = additionalProperties.getProperty("egeria_kafka_consumer");
            this.copyProperties(propertiesObject, this.consumerEgeriaProperties);
        }
        catch (Throwable error) {
            KafkaOpenMetadataTopicConnectorAuditCode auditCode = KafkaOpenMetadataTopicConnectorAuditCode.UNABLE_TO_PARSE_ADDITIONAL_PROPERTIES;
            this.auditLog.logRecord("initializeKafkaProperties", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.topicName, error.getClass().getName(), error.getMessage()), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void copyProperties(Object propertiesObject, Properties target) {
        if (propertiesObject != null) {
            Map propertiesMap = (Map)propertiesObject;
            for (Map.Entry entry : propertiesMap.entrySet()) {
                target.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void start() throws ConnectorCheckedException {
        String threadHeader = "Kafka-";
        this.initializeTopic();
        KafkaOpenMetadataEventConsumerConfiguration consumerConfig = new KafkaOpenMetadataEventConsumerConfiguration(this.consumerEgeriaProperties);
        this.consumer = new KafkaOpenMetadataEventConsumer(this.topicName, this.serverId, consumerConfig, this.consumerProperties, this, this.auditLog);
        Thread consumerThread = new Thread((Runnable)this.consumer, "Kafka-Consumer-" + this.topicName);
        consumerThread.start();
        this.producer = new KafkaOpenMetadataEventProducer(this.topicName, this.serverId, this.producerProperties, this, this.auditLog);
        Thread producerThread = new Thread((Runnable)this.producer, "Kafka-Producer-" + this.topicName);
        producerThread.start();
        super.start();
    }

    public void sendEvent(String event) throws ConnectorCheckedException {
        if (this.producer != null) {
            this.producer.sendEvent(event);
        }
    }

    protected List<String> checkForEvents() {
        ArrayList<String> newEvents = null;
        if (this.incomingEventsList != null && !this.incomingEventsList.isEmpty()) {
            log.debug("Checking for events.  Number of found events: {0}", (Object)this.incomingEventsList.size());
            newEvents = new ArrayList<String>(this.incomingEventsList);
            this.incomingEventsList.removeAll(newEvents);
        }
        return newEvents;
    }

    void distributeToListeners(String event) {
        log.debug("distribute event to listeners" + event);
        this.incomingEventsList.add(event);
    }

    public void disconnect() throws ConnectorCheckedException {
        String actionDescription = "disconnect";
        this.consumer.safeCloseConsumer();
        this.producer.safeCloseProducer();
        super.disconnect();
        KafkaOpenMetadataTopicConnectorAuditCode auditCode = KafkaOpenMetadataTopicConnectorAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("disconnect", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.topicName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    public String getPrintableProperties(Properties liveProperties) {
        String mask = "[hidden]";
        String secretProperty1 = "sasl.jaas.config";
        String secretProperty2 = "ssl.truststore.password";
        String printableProperties = null;
        if (liveProperties != null) {
            Set<Object> propertyNames = liveProperties.keySet();
            for (Object name : propertyNames) {
                String propertyName = name.toString();
                printableProperties = printableProperties == null ? "[" : printableProperties + ", ";
                if ("sasl.jaas.config".equals(propertyName) || "ssl.truststore.password".equals(propertyName)) {
                    printableProperties = printableProperties + propertyName + "->" + "[hidden]";
                    continue;
                }
                String propertyValue = liveProperties.getProperty(propertyName);
                printableProperties = printableProperties + propertyName + "->" + propertyValue;
            }
        }
        printableProperties = printableProperties != null ? printableProperties + ']' : "<none>";
        return printableProperties;
    }

    public int getNumberOfUnprocessedEvents() {
        return this.incomingEventsList.size();
    }
}

