/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.eventbus.topic.kafka;

import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KafkaOpenMetadataTopicConnectorErrorCode {
    ERROR_SENDING_EVENT(400, "OCF-KAFKA-TOPIC-CONNECTOR-400-001 ", "An unexpected {0} exception was caught while sending an event to topic {1}.  The message in the exception was: {2}", "The system is unable to send the event.", "Review the exception that was returned from the send.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private KafkaOpenMetadataTopicConnectorErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        log.debug(String.format("<== KafkaOpenMetadataTopicConnectorErrorCode.getMessage(%s)", Arrays.toString(params)));
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("==> KafkaOpenMetadataTopicConnectorErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String toString() {
        return "KafkaOpenMetadataTopicConnectorErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + '}';
    }

    static {
        log = LoggerFactory.getLogger(KafkaOpenMetadataTopicConnectorErrorCode.class);
    }
}

