/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.eventbus.topic.kafka;

import java.util.Properties;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataEventConsumerProperty;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicConnectorAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public class KafkaOpenMetadataEventConsumerConfiguration {
    private final Properties properties;
    private OMRSAuditLog auditLog;

    public KafkaOpenMetadataEventConsumerConfiguration(Properties properties, OMRSAuditLog auditLog) {
        this.properties = properties;
        this.auditLog = auditLog;
    }

    public int getIntProperty(KafkaOpenMetadataEventConsumerProperty property) {
        return Integer.parseInt(this.getProperty(property));
    }

    public long getLongProperty(KafkaOpenMetadataEventConsumerProperty property) {
        return Long.parseLong(this.getProperty(property));
    }

    public String getProperty(KafkaOpenMetadataEventConsumerProperty property) {
        String value = this.properties.getProperty(property.getPropertyName(), property.getDefaultValue());
        if (value == null || value.trim().length() == 0) {
            String actionDescription = "getProperty";
            KafkaOpenMetadataTopicConnectorAuditCode auditCode = KafkaOpenMetadataTopicConnectorAuditCode.MISSING_PROPERTY;
            this.auditLog.logRecord("getProperty", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(property.getPropertyName()), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return "0";
        }
        return value;
    }
}

