/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.eventbus.topic.kafka;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataEventConsumer;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataEventConsumerConfiguration;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataEventProducer;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.IncomingEvent;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOpenMetadataTopicConnector
extends OpenMetadataTopicConnector {
    static final String ENABLE_AUTO_COMMIT_PROPERTY = "enable.auto.commit";
    private static final Logger log = LoggerFactory.getLogger(KafkaOpenMetadataTopicConnector.class);
    private Properties producerProperties = new Properties();
    private Properties consumerEgeriaProperties = new Properties();
    private Properties consumerProperties = new Properties();
    private KafkaOpenMetadataEventConsumer consumer = null;
    private KafkaOpenMetadataEventProducer producer = null;
    private String topicName = null;
    private String serverId = null;
    private List<IncomingEvent> incomingEventsList = Collections.synchronizedList(new ArrayList());
    private KafkaProducerExecutor executor = null;
    final String threadHeader = "Kafka-";
    Thread consumerThread;
    Thread producerThread;

    public KafkaOpenMetadataTopicConnector() {
        this.producerProperties.put("bootstrap.servers", "localhost:9092");
        this.producerProperties.put("acks", "all");
        this.producerProperties.put("retries", (Object)1);
        this.producerProperties.put("batch.size", (Object)16384);
        this.producerProperties.put("linger.ms", (Object)0);
        this.producerProperties.put("buffer.memory", (Object)0x2000000);
        this.producerProperties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producerProperties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.consumerProperties.put("bootstrap.servers", "localhost:9092");
        this.consumerProperties.put(ENABLE_AUTO_COMMIT_PROPERTY, "true");
        this.consumerProperties.put("auto.commit.interval.ms", "1000");
        this.consumerProperties.put("session.timeout.ms", "30000");
        this.consumerProperties.put("max.partition.fetch.bytes", (Object)0xA00000);
        this.consumerProperties.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.consumerProperties.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
    }

    private void initializeTopic() {
        String actionDescription = "initialize";
        super.initialize(this.connectorInstanceId, this.connectionProperties);
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.topicName = endpoint.getAddress();
            Map configurationProperties = this.connectionProperties.getConfigurationProperties();
            if (configurationProperties != null) {
                this.initializeKafkaProperties(configurationProperties);
                this.serverId = (String)configurationProperties.get("local.server.id");
                this.consumerProperties.put("group.id", this.serverId);
                if (this.auditLog != null) {
                    this.auditLog.logMessage("initialize", KafkaOpenMetadataTopicConnectorAuditCode.SERVICE_INITIALIZING.getMessageDefinition(this.topicName, this.serverId));
                }
            } else if (this.auditLog != null) {
                this.auditLog.logMessage("initialize", KafkaOpenMetadataTopicConnectorAuditCode.NULL_ADDITIONAL_PROPERTIES.getMessageDefinition(this.topicName));
            }
        } else if (this.auditLog != null) {
            this.auditLog.logMessage("initialize", KafkaOpenMetadataTopicConnectorAuditCode.NO_TOPIC_NAME.getMessageDefinition());
        }
    }

    private void initializeKafkaProperties(Map<String, Object> configurationProperties) {
        String actionDescription = "initializeKafkaProperties";
        try {
            Object propertiesObject = configurationProperties.get("producer");
            this.copyProperties(propertiesObject, this.producerProperties);
            propertiesObject = configurationProperties.get("consumer");
            this.copyProperties(propertiesObject, this.consumerProperties);
            propertiesObject = configurationProperties.get("egeria_kafka_consumer");
            this.copyProperties(propertiesObject, this.consumerEgeriaProperties);
        }
        catch (Throwable error) {
            this.auditLog.logMessage("initializeKafkaProperties", KafkaOpenMetadataTopicConnectorAuditCode.UNABLE_TO_PARSE_CONFIG_PROPERTIES.getMessageDefinition(this.topicName, error.getClass().getName(), error.getMessage()));
        }
    }

    private void copyProperties(Object propertiesObject, Properties target) {
        if (propertiesObject != null) {
            try {
                Map propertiesMap = (Map)propertiesObject;
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    target.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void start() throws ConnectorCheckedException {
        this.initializeTopic();
        KafkaOpenMetadataEventConsumerConfiguration consumerConfig = new KafkaOpenMetadataEventConsumerConfiguration(this.consumerEgeriaProperties, this.auditLog);
        this.consumer = new KafkaOpenMetadataEventConsumer(this.topicName, this.serverId, consumerConfig, this.consumerProperties, this, this.auditLog);
        this.consumerThread = new Thread((Runnable)this.consumer, "Kafka-Consumer-" + this.topicName);
        this.consumerThread.start();
        this.producer = new KafkaOpenMetadataEventProducer(this.topicName, this.serverId, this.producerProperties, this, this.auditLog);
        this.producerThread = new Thread((Runnable)this.producer, "Kafka-Producer-" + this.topicName);
        this.executor = new KafkaProducerExecutor();
        this.executor.execute(this.producerThread);
        super.start();
    }

    public void sendEvent(String event) throws ConnectorCheckedException {
        if (this.producer != null) {
            this.producer.sendEvent(event);
        }
    }

    protected List<IncomingEvent> checkForIncomingEvents() {
        ArrayList<IncomingEvent> newEvents = null;
        if (this.incomingEventsList != null && !this.incomingEventsList.isEmpty()) {
            log.debug("Checking for events.  Number of found events: {0}", (Object)this.incomingEventsList.size());
            newEvents = new ArrayList<IncomingEvent>(this.incomingEventsList);
            this.incomingEventsList.removeAll(newEvents);
        }
        return newEvents;
    }

    void distributeToListeners(IncomingEvent event) {
        log.debug("distribute event to listeners" + event);
        this.incomingEventsList.add(event);
    }

    public void disconnect() throws ConnectorCheckedException {
        String actionDescription = "disconnect";
        this.consumer.safeCloseConsumer();
        this.producer.safeCloseProducer();
        super.disconnect();
        this.auditLog.logMessage("disconnect", KafkaOpenMetadataTopicConnectorAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.topicName));
    }

    int getNumberOfUnprocessedEvents() {
        return this.incomingEventsList.size();
    }

    private class KafkaProducerExecutor
    extends ThreadPoolExecutor {
        KafkaProducerExecutor() {
            super(1, 1, Long.MAX_VALUE, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>(1));
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            KafkaOpenMetadataTopicConnector.this.producer = new KafkaOpenMetadataEventProducer(KafkaOpenMetadataTopicConnector.this.topicName, KafkaOpenMetadataTopicConnector.this.serverId, KafkaOpenMetadataTopicConnector.this.producerProperties, KafkaOpenMetadataTopicConnector.this, KafkaOpenMetadataTopicConnector.this.auditLog);
            KafkaOpenMetadataTopicConnector.this.producerThread = new Thread((Runnable)KafkaOpenMetadataTopicConnector.this.producer, "Kafka-Producer-" + KafkaOpenMetadataTopicConnector.this.topicName);
            KafkaOpenMetadataTopicConnector.this.executor.execute(KafkaOpenMetadataTopicConnector.this.producerThread);
        }
    }
}

