/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.eventbus.topic.kafka;

import java.util.Properties;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataEventConsumerProperty;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicConnectorAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;

public class KafkaOpenMetadataEventConsumerConfiguration {
    private final Properties properties;
    private final AuditLog auditLog;

    KafkaOpenMetadataEventConsumerConfiguration(Properties properties, AuditLog auditLog) {
        this.properties = properties;
        this.auditLog = auditLog;
    }

    int getIntProperty(KafkaOpenMetadataEventConsumerProperty property) {
        return Integer.parseInt(this.getProperty(property));
    }

    long getLongProperty(KafkaOpenMetadataEventConsumerProperty property) {
        return Long.parseLong(this.getProperty(property));
    }

    public String getProperty(KafkaOpenMetadataEventConsumerProperty property) {
        String value = this.properties.getProperty(property.getPropertyName(), property.getDefaultValue());
        if (value == null || value.trim().length() == 0) {
            String actionDescription = "getProperty";
            this.auditLog.logMessage("getProperty", KafkaOpenMetadataTopicConnectorAuditCode.MISSING_PROPERTY.getMessageDefinition(property.getPropertyName()));
            return "0";
        }
        return value;
    }
}

