/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.lineage.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum LineageIntegratorAuditCode implements AuditLogMessageSet
{
    CONTEXT_INITIALIZING("OMIS-LINEAGE-INTEGRATOR-0001", OMRSAuditLogRecordSeverity.STARTUP, "The lineage integrator context manager is being initialized for calls to server {0} on platform {1}", "The Lineage Integrator OMIS is initializing its context manager.", "Verify that the start up sequence goes on to initialize the context for each connector configured for this service."),
    CONNECTOR_CONTEXT_INITIALIZING("OMIS-LINEAGE-INTEGRATOR-0002", OMRSAuditLogRecordSeverity.STARTUP, "Creating context for integration connector {0} ({1}) connecting to third party technology {2} with permitted synchronization of {3} and service options of {4}", "A new context is created for an integration connector.  This acts as a client to the open metadata repositories enabling the integration connector to synchronize open metadata with the third party technology's metadata", "Verify that this connector is being started with the correct configuration."),
    PERMITTED_SYNCHRONIZATION("OMIS-LINEAGE-INTEGRATOR-0003", OMRSAuditLogRecordSeverity.STARTUP, "The context for connector {0} has its permitted synchronization set to {1}", "The context is set up to ensure that the connector can only issue requests that support the permitted synchronization.  If the connector issues requests that are not permitted it is returned UserNotAuthorizedExceptions.", "Check that this permitted synchronized value is as expected.  If it is not,change the configuration for this connector and restart the integration daemon."),
    NULL_CONTEXT("OMIS-LINEAGE-INTEGRATOR-0004", OMRSAuditLogRecordSeverity.ERROR, "Integration connector {0} has a null context", "The integration connector is running but does not have a context.  This is a timing issue in the integration daemon.", "Gather information about the connector's configuration, the types of metadata it was integrating, the audit log messages from the integration daemon and its partner metadata server.  Then contact the Egeria community to get help."),
    OPEN_LINEAGE_FORMAT_ERROR("OMIS-LINEAGE-INTEGRATOR-0005", OMRSAuditLogRecordSeverity.ERROR, "A {0} exception with message {1} occurred when parsing open lineage event: {2}", "The Lineage Integrator OMIS is unable to parse an incoming open lineage event into Egeria's OpenLineageRunEvent bean.  This may be due to either (1) an invalid open lineage event, or (2) Egeria's OpenLineageRunEvent not supporting an advancement in the open lineage standard.  The raw event is passed to the listening connectors with a null OpenLineageRunEvent bean.  The connector can use the open lineage standard server to process the event facet by facet.", "Verify the format of the open lineage event.  If incorrect, seek the source of the event.  If correct, look to enhance Egeria's OpenLineageRunEvent."),
    OPEN_LINEAGE_PUBLISH_ERROR("OMIS-LINEAGE-INTEGRATOR-0006", OMRSAuditLogRecordSeverity.EXCEPTION, "A {0} exception with message {1} occurred when a listening integration connector tried to push an OpenLineage event", "The Lineage Integrator OMIS has caught the exception and will continue to pass the event to the remaining listening integration connectors.", "Look at the resulting stack trace to understand what went wrong in the called integration connector.");

    AuditLogMessageDefinition messageDefinition;

    private LineageIntegratorAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "LineageIntegratorAuditCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

