/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.lineage.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GovernanceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NextGovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.PortElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ForeignKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageEventListener;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageListenerManager;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;

public class LineageIntegratorContext
implements OpenLineageListenerManager {
    private OpenLineageListenerManager openLineageListenerManager;
    private DataAssetExchangeClient dataAssetExchangeClient;
    private LineageExchangeClient lineageExchangeClient;
    private GovernanceExchangeClient governanceExchangeClient;
    private AssetManagerEventClient eventClient;
    private String userId;
    private String assetManagerGUID;
    private String assetManagerName;
    private String connectorName;
    private String integrationServiceName;
    private AuditLog auditLog;

    public LineageIntegratorContext(OpenLineageListenerManager openLineageListenerManager, DataAssetExchangeClient dataAssetExchangeClient, LineageExchangeClient lineageExchangeClient, GovernanceExchangeClient governanceExchangeClient, AssetManagerEventClient eventClient, String userId, String assetManagerGUID, String assetManagerName, String connectorName, String integrationServiceName, AuditLog auditLog) {
        this.openLineageListenerManager = openLineageListenerManager;
        this.dataAssetExchangeClient = dataAssetExchangeClient;
        this.lineageExchangeClient = lineageExchangeClient;
        this.governanceExchangeClient = governanceExchangeClient;
        this.eventClient = eventClient;
        this.userId = userId;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.connectorName = connectorName;
        this.integrationServiceName = integrationServiceName;
        this.auditLog = auditLog;
    }

    @Override
    public void registerListener(OpenLineageEventListener listener) {
        this.openLineageListenerManager.registerListener(listener);
    }

    @Override
    public void publishOpenLineageRunEvent(String rawEvent) {
        this.openLineageListenerManager.publishOpenLineageRunEvent(rawEvent);
    }

    @Override
    public void publishOpenLineageRunEvent(OpenLineageRunEvent event) {
        this.openLineageListenerManager.publishOpenLineageRunEvent(event);
    }

    public void registerListener(AssetManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createDataAsset(boolean assetManagerIsHome, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, null, null, null, null, null, null, assetProperties);
    }

    public String createDataAssetFromTemplate(boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createDataAssetFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, null, null, null, null, null, null, templateProperties);
    }

    public void updateDataAsset(String assetGUID, boolean isMergeUpdate, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.updateDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, null, isMergeUpdate, assetProperties);
    }

    public void publishDataAsset(String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.publishDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID);
    }

    public void withdrawDataAsset(String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.withdrawDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID);
    }

    public void removeDataAsset(String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.removeDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, null);
    }

    public void setDataAssetAsReferenceData(String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setDataAssetAsReferenceData(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, null);
    }

    public void clearDataAssetAsReferenceData(String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearDataAssetAsReferenceData(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, null);
    }

    public List<DataAssetElement> findDataAssets(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.findDataAssets(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public List<DataAssetElement> getDataAssetsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public List<DataAssetElement> getDataAssetsForAssetManager(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize);
    }

    public DataAssetElement getDataAssetByGUID(String openMetadataGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, openMetadataGUID);
    }

    public String createSchemaType(boolean assetManagerIsHome, String schemaTypeGUID, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, null, null, null, null, null, null, schemaTypeProperties);
    }

    public String createSchemaTypeFromTemplate(boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createSchemaTypeFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, null, null, null, null, null, null, templateProperties);
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.updateSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, null, isMergeUpdate, schemaTypeProperties);
    }

    public void setupSchemaTypeParent(boolean assetManagerIsHome, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setupSchemaTypeParent(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaTypeGUID, parentElementGUID, parentElementTypeName);
    }

    public void clearSchemaTypeParent(String schemaTypeGUID, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearSchemaTypeParent(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, parentElementGUID, parentElementTypeName);
    }

    public void removeSchemaType(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.removeSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, null);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.findSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaTypeForElement(this.userId, this.assetManagerGUID, this.assetManagerName, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaTypeByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaTypeByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaTypeParent(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID);
    }

    public String createSchemaAttribute(boolean assetManagerIsHome, String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createSchemaAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaElementGUID, null, null, null, null, null, null, schemaAttributeProperties);
    }

    public String createSchemaAttributeFromTemplate(boolean assetManagerIsHome, String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createSchemaAttributeFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaElementGUID, templateGUID, null, null, null, null, null, null, templateProperties);
    }

    public void updateSchemaAttribute(String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.updateSchemaAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, null, isMergeUpdate, schemaAttributeProperties);
    }

    public void setSchemaElementAsCalculatedValue(boolean assetManagerIsHome, String schemaElementGUID, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setSchemaElementAsCalculatedValue(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaElementGUID, null, formula);
    }

    public void clearSchemaElementAsCalculatedValue(String schemaElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearSchemaElementAsCalculatedValue(this.userId, this.assetManagerGUID, this.assetManagerName, schemaElementGUID, null);
    }

    public void setupColumnAsPrimaryKey(boolean assetManagerIsHome, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, String primaryKeyName, KeyPattern primaryKeyPattern) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setupColumnAsPrimaryKey(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaAttributeGUID, schemaAttributeExternalIdentifier, primaryKeyName, primaryKeyPattern);
    }

    public void clearColumnAsPrimaryKey(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearColumnAsPrimaryKey(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, null);
    }

    public void setupForeignKeyRelationship(boolean assetManagerIsHome, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setupForeignKeyRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, primaryKeyGUID, foreignKeyGUID, foreignKeyProperties);
    }

    public void updateForeignKeyRelationship(String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.updateForeignKeyRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, primaryKeyGUID, foreignKeyGUID, foreignKeyProperties);
    }

    public void clearForeignKeyRelationship(String primaryKeyGUID, String foreignKeyGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearForeignKeyRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, primaryKeyGUID, foreignKeyGUID);
    }

    public void removeSchemaAttribute(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.removeSchemaAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, null);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.findSchemaAttributes(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getNestedSchemaAttributes(String parentSchemaElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getNestedSchemaAttributes(this.userId, this.assetManagerGUID, this.assetManagerName, parentSchemaElementGUID, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaAttributesByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaAttributeByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID);
    }

    public String createProcess(boolean assetManagerIsHome, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.createProcess(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, null, null, null, null, null, null, processProperties);
    }

    public String createProcessFromTemplate(boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.createProcessFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, null, null, null, null, null, null, templateProperties);
    }

    public void updateProcess(String processGUID, boolean isMergeUpdate, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, null, isMergeUpdate, processProperties);
    }

    public void updateProcessStatus(String processGUID, ProcessStatus processStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateProcessStatus(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, null, processStatus);
    }

    public void setupProcessParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentType containmentType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupProcessParent(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, parentProcessGUID, childProcessGUID, containmentType);
    }

    public void clearProcessParent(String parentProcessGUID, String childProcessGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearProcessParent(this.userId, this.assetManagerGUID, this.assetManagerName, parentProcessGUID, childProcessGUID);
    }

    public void publishProcess(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.publishProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID);
    }

    public void withdrawProcess(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.withdrawProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID);
    }

    public void removeProcess(String processGUID, String processExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.removeProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, processExternalIdentifier);
    }

    public List<ProcessElement> findProcesses(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.findProcesses(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public List<ProcessElement> getProcessesForAssetManager(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessesForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize);
    }

    public List<ProcessElement> getProcessesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessesByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public ProcessElement getProcessByGUID(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID);
    }

    public ProcessElement getProcessParent(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessParent(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID);
    }

    public List<ProcessElement> getSubProcesses(String processGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getSubProcesses(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, startFrom, pageSize);
    }

    public String createPort(boolean assetManagerIsHome, String processGUID, PortProperties portProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.createPort(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, processGUID, null, null, null, null, null, null, portProperties);
    }

    public void updatePort(String portGUID, PortProperties portProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updatePort(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, null, portProperties);
    }

    public void setupProcessPort(boolean assetManagerIsHome, String processGUID, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupProcessPort(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, processGUID, portGUID);
    }

    public void clearProcessPort(String processGUID, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearProcessPort(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, portGUID);
    }

    public void setupPortDelegation(boolean assetManagerIsHome, String portOneGUID, String portTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupPortDelegation(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, portOneGUID, portTwoGUID);
    }

    public void clearPortDelegation(String portOneGUID, String portTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearPortDelegation(this.userId, this.assetManagerGUID, this.assetManagerName, portOneGUID, portTwoGUID);
    }

    public void setupPortSchemaType(boolean assetManagerIsHome, String portGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupPortSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, portGUID, schemaTypeGUID);
    }

    public void clearPortSchemaType(String portGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearPortSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, schemaTypeGUID);
    }

    public void removePort(String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.removePort(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, null);
    }

    public List<PortElement> findPorts(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.findPorts(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public List<PortElement> getPortsForProcess(String processGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortsForProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, startFrom, pageSize);
    }

    public List<PortElement> getPortUse(String portGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortUse(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, startFrom, pageSize);
    }

    public PortElement getPortDelegation(String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortDelegation(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID);
    }

    public List<PortElement> getPortsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortsByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public PortElement getPortByGUID(String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID);
    }

    public void setBusinessSignificant(String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setBusinessSignificant(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, null);
    }

    public void clearBusinessSignificant(String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearBusinessSignificant(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, null);
    }

    public String setupDataFlow(boolean assetManagerIsHome, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.setupDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, dataSupplierGUID, dataConsumerGUID, qualifiedName, description, formula);
    }

    public DataFlowElement getDataFlow(String dataSupplierGUID, String dataConsumerGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, dataSupplierGUID, dataConsumerGUID, qualifiedName);
    }

    public void updateDataFlow(String dataFlowGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, dataFlowGUID, qualifiedName, description, formula);
    }

    public void clearDataFlow(String dataFlowGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, dataFlowGUID);
    }

    public List<DataFlowElement> getDataFlowConsumers(String dataSupplierGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlowConsumers(this.userId, this.assetManagerGUID, this.assetManagerName, dataSupplierGUID);
    }

    public List<DataFlowElement> getDataFlowSuppliers(String dataConsumerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlowSuppliers(this.userId, this.assetManagerGUID, this.assetManagerName, dataConsumerGUID);
    }

    public String setupControlFlow(boolean assetManagerIsHome, String currentStepGUID, String nextStepGUID, String qualifiedName, String description, String guard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.setupControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, currentStepGUID, nextStepGUID, qualifiedName, description, guard);
    }

    public ControlFlowElement getControlFlow(String currentStepGUID, String nextStepGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, currentStepGUID, nextStepGUID, qualifiedName);
    }

    public void updateControlFlow(String controlFlowGUID, String qualifiedName, String description, String guard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, controlFlowGUID, qualifiedName, description, guard);
    }

    public void clearControlFlow(String controlFlowGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, controlFlowGUID);
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String currentStepGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlowNextSteps(this.userId, this.assetManagerGUID, this.assetManagerName, currentStepGUID);
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String currentStepGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlowPreviousSteps(this.userId, this.assetManagerGUID, this.assetManagerName, currentStepGUID);
    }

    public String setupProcessCall(boolean assetManagerIsHome, String callerGUID, String calledGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.setupProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, callerGUID, calledGUID, qualifiedName, description, formula);
    }

    public ProcessCallElement getProcessCall(String callerGUID, String calledGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, callerGUID, calledGUID, qualifiedName);
    }

    public void updateProcessCall(String processCallGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, processCallGUID, qualifiedName, description, formula);
    }

    public void clearProcessCall(String processCallGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, processCallGUID);
    }

    public List<ProcessCallElement> getProcessCalled(String callerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCalled(this.userId, this.assetManagerGUID, this.assetManagerName, callerGUID);
    }

    public List<ProcessCallElement> getProcessCallers(String calledGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCallers(this.userId, this.assetManagerGUID, this.assetManagerName, calledGUID);
    }

    public void setupLineageMapping(String sourceElementGUID, String destinationElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupLineageMapping(this.userId, this.assetManagerGUID, this.assetManagerName, sourceElementGUID, destinationElementGUID);
    }

    public void clearLineageMapping(String sourceElementGUID, String destinationElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearLineageMapping(this.userId, this.assetManagerGUID, this.assetManagerName, sourceElementGUID, destinationElementGUID);
    }

    public List<GovernanceActionProcessElement> findGovernanceActionProcesses(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.findGovernanceActionProcesses(this.userId, searchString, startFrom, pageSize);
    }

    public List<GovernanceActionProcessElement> getGovernanceActionProcessesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActionProcessesByName(this.userId, name, startFrom, pageSize);
    }

    public GovernanceActionProcessElement getGovernanceActionProcessByGUID(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActionProcessByGUID(this.userId, processGUID);
    }

    public List<GovernanceActionTypeElement> findGovernanceActionTypes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.findGovernanceActionTypes(this.userId, searchString, startFrom, pageSize);
    }

    public List<GovernanceActionTypeElement> getGovernanceActionTypesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActionTypesByName(this.userId, name, startFrom, pageSize);
    }

    public GovernanceActionTypeElement getGovernanceActionTypeByGUID(String actionTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActionTypeByGUID(this.userId, actionTypeGUID);
    }

    public GovernanceActionTypeElement getFirstActionType(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getFirstActionType(this.userId, processGUID);
    }

    public List<NextGovernanceActionTypeElement> getNextGovernanceActionTypes(String actionTypeGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getNextGovernanceActionTypes(this.userId, actionTypeGUID, startFrom, pageSize);
    }

    public GovernanceActionElement getGovernanceAction(String governanceActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceAction(this.userId, governanceActionGUID);
    }

    public List<GovernanceActionElement> getGovernanceActions(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActions(this.userId, startFrom, pageSize);
    }

    public List<GovernanceActionElement> getActiveGovernanceActions(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getActiveGovernanceActions(this.userId, startFrom, pageSize);
    }
}

