/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.lineage.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GovernanceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NextGovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.PortElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RelationshipElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ControlFlowProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataFlowProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ForeignKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.LineageMappingProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessCallProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessContainmentProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageEventListener;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageListenerManager;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;

public class LineageIntegratorContext
extends IntegrationContext
implements OpenLineageListenerManager {
    private final OpenLineageListenerManager openLineageListenerManager;
    private final DataAssetExchangeClient dataAssetExchangeClient;
    private final LineageExchangeClient lineageExchangeClient;
    private final GovernanceExchangeClient governanceExchangeClient;
    private final AssetManagerEventClient eventClient;
    private final String integrationServiceName;
    private final AuditLog auditLog;
    private boolean forLineage = true;
    private final boolean forDuplicateProcessing = false;

    public LineageIntegratorContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, OpenMetadataClient openMetadataStoreClient, OpenLineageListenerManager openLineageListenerManager, DataAssetExchangeClient dataAssetExchangeClient, LineageExchangeClient lineageExchangeClient, GovernanceExchangeClient governanceExchangeClient, AssetManagerEventClient eventClient, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String integrationConnectorGUID, String externalSourceGUID, String externalSourceName, String integrationServiceName, int maxPageSize, AuditLog auditLog) {
        super(connectorId, connectorName, connectorUserId, serverName, openIntegrationClient, openMetadataStoreClient, generateIntegrationReport, permittedSynchronization, externalSourceGUID, externalSourceName, integrationConnectorGUID, maxPageSize);
        this.openLineageListenerManager = openLineageListenerManager;
        this.dataAssetExchangeClient = dataAssetExchangeClient;
        this.lineageExchangeClient = lineageExchangeClient;
        this.governanceExchangeClient = governanceExchangeClient;
        this.eventClient = eventClient;
        this.integrationServiceName = integrationServiceName;
        this.auditLog = auditLog;
    }

    public String getIntegrationServiceName() {
        return this.integrationServiceName;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    @Override
    public void registerListener(OpenLineageEventListener listener) {
        this.openLineageListenerManager.registerListener(listener);
    }

    @Override
    public void publishOpenLineageRunEvent(String rawEvent) {
        this.openLineageListenerManager.publishOpenLineageRunEvent(rawEvent);
    }

    @Override
    public void publishOpenLineageRunEvent(OpenLineageRunEvent event) {
        this.openLineageListenerManager.publishOpenLineageRunEvent(event);
    }

    public void registerListener(AssetManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createDataAsset(boolean assetManagerIsHome, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createDataAsset(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, null, assetProperties);
    }

    public String createDataAssetFromTemplate(boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createDataAssetFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, templateGUID, null, templateProperties);
    }

    public void updateDataAsset(String assetGUID, boolean isMergeUpdate, DataAssetProperties assetProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.updateDataAsset(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, null, isMergeUpdate, assetProperties, effectiveTime, this.forLineage, false);
    }

    public void publishDataAsset(String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.publishDataAsset(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, effectiveTime, this.forLineage, false);
    }

    public void withdrawDataAsset(String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.withdrawDataAsset(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, effectiveTime, this.forLineage, false);
    }

    public void removeDataAsset(String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.removeDataAsset(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, null, effectiveTime, this.forLineage, false);
    }

    public void setDataAssetAsReferenceData(String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setDataAssetAsReferenceData(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, null, effectiveTime, this.forLineage, false);
    }

    public void clearDataAssetAsReferenceData(String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearDataAssetAsReferenceData(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, null, effectiveTime, this.forLineage, false);
    }

    public String setupRelatedDataAsset(boolean assetManagerIsHome, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, RelationshipProperties relationshipProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.setupRelatedDataAsset(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, relationshipTypeName, fromAssetGUID, toAssetGUID, relationshipProperties, effectiveTime, this.forLineage, false);
    }

    public RelationshipElement getAssetRelationship(String relationshipTypeName, String fromAssetGUID, String toAssetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getAssetRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipTypeName, fromAssetGUID, toAssetGUID, effectiveTime, this.forLineage, false);
    }

    public void updateAssetRelationship(String relationshipTypeName, String relationshipGUID, boolean isMergeUpdate, RelationshipProperties relationshipProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.updateAssetRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipTypeName, relationshipGUID, isMergeUpdate, relationshipProperties, effectiveTime, this.forLineage, false);
    }

    public void clearAssetRelationship(String relationshipTypeName, String relationshipGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearAssetRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipTypeName, relationshipGUID, effectiveTime, this.forLineage, false);
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd2(String relationshipTypeName, String fromAssetGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getRelatedAssetsAtEnd2(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipTypeName, fromAssetGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd1(String relationshipTypeName, String toAssetGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getRelatedAssetsAtEnd1(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipTypeName, toAssetGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<DataAssetElement> findDataAssets(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.findDataAssets(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<DataAssetElement> getDataAssetsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<DataAssetElement> getDataAssetsForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsForAssetManager(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public DataAssetElement getDataAssetByGUID(String openMetadataGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetByGUID(this.userId, this.externalSourceGUID, this.externalSourceName, openMetadataGUID, effectiveTime, this.forLineage, false);
    }

    public String createSchemaType(boolean assetManagerIsHome, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, null, this.forLineage, false, schemaTypeProperties);
    }

    public String createAnchoredSchemaType(boolean assetManagerIsHome, String anchorGUID, ExternalIdentifierProperties externalIdentifierProperties, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createAnchoredSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, anchorGUID, externalIdentifierProperties, this.forLineage, false, schemaTypeProperties);
    }

    public String createSchemaTypeFromTemplate(boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createSchemaTypeFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, templateGUID, null, templateProperties);
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.updateSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeGUID, null, isMergeUpdate, schemaTypeProperties, effectiveTime, this.forLineage, false);
    }

    public void setupSchemaTypeParent(boolean assetManagerIsHome, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, RelationshipProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setupSchemaTypeParent(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, schemaTypeGUID, parentElementGUID, parentElementTypeName, effectiveTime, this.forLineage, false, properties);
    }

    public void clearSchemaTypeParent(String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearSchemaTypeParent(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeGUID, parentElementGUID, parentElementTypeName, effectiveTime, this.forLineage, false);
    }

    public void setupSchemaElementRelationship(boolean assetManagerIsHome, String endOneGUID, String endTwoGUID, String relationshipName, Date effectiveTime, RelationshipProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setupSchemaElementRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, endOneGUID, endTwoGUID, relationshipName, effectiveTime, this.forLineage, false, properties);
    }

    public void clearSchemaElementRelationship(String endOneGUID, String endTwoGUID, String relationshipName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearSchemaElementRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, endOneGUID, endTwoGUID, relationshipName, effectiveTime, this.forLineage, false);
    }

    public void removeSchemaType(String schemaTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.removeSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeGUID, null, effectiveTime, this.forLineage, false);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.findSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaTypeForElement(this.userId, this.externalSourceGUID, this.externalSourceName, parentElementGUID, parentElementTypeName, effectiveTime, this.forLineage, false);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaTypeByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaTypeByGUID(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeGUID, effectiveTime, this.forLineage, false);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaTypeParent(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeGUID, effectiveTime, this.forLineage, false);
    }

    public String createSchemaAttribute(boolean assetManagerIsHome, String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createSchemaAttribute(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, schemaElementGUID, null, schemaAttributeProperties, effectiveTime, this.forLineage, false);
    }

    public String createSchemaAttributeFromTemplate(boolean assetManagerIsHome, String schemaElementGUID, String templateGUID, TemplateProperties templateProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.createSchemaAttributeFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, schemaElementGUID, templateGUID, null, templateProperties, effectiveTime, this.forLineage, false);
    }

    public void updateSchemaAttribute(String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.updateSchemaAttribute(this.userId, this.externalSourceGUID, this.externalSourceName, schemaAttributeGUID, null, isMergeUpdate, schemaAttributeProperties, effectiveTime, this.forLineage, false);
    }

    public void setSchemaElementAsCalculatedValue(boolean assetManagerIsHome, String schemaElementGUID, String formula, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setSchemaElementAsCalculatedValue(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, schemaElementGUID, null, formula, effectiveTime, this.forLineage, false);
    }

    public void clearSchemaElementAsCalculatedValue(String schemaElementGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearSchemaElementAsCalculatedValue(this.userId, this.externalSourceGUID, this.externalSourceName, schemaElementGUID, null, effectiveTime, this.forLineage, false);
    }

    public void setupColumnAsPrimaryKey(boolean assetManagerIsHome, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, String primaryKeyName, KeyPattern primaryKeyPattern, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setupColumnAsPrimaryKey(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, schemaAttributeGUID, schemaAttributeExternalIdentifier, primaryKeyName, primaryKeyPattern, effectiveTime, this.forLineage, false);
    }

    public void clearColumnAsPrimaryKey(String schemaAttributeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearColumnAsPrimaryKey(this.userId, this.externalSourceGUID, this.externalSourceName, schemaAttributeGUID, null, effectiveTime, this.forLineage, false);
    }

    public void setupForeignKeyRelationship(boolean assetManagerIsHome, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.setupForeignKeyRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, primaryKeyGUID, foreignKeyGUID, foreignKeyProperties, effectiveTime, this.forLineage, false);
    }

    public void updateForeignKeyRelationship(String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.updateForeignKeyRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, primaryKeyGUID, foreignKeyGUID, foreignKeyProperties, effectiveTime, this.forLineage, false);
    }

    public void clearForeignKeyRelationship(String primaryKeyGUID, String foreignKeyGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.clearForeignKeyRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, primaryKeyGUID, foreignKeyGUID, effectiveTime, this.forLineage, false);
    }

    public void removeSchemaAttribute(String schemaAttributeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetExchangeClient.removeSchemaAttribute(this.userId, this.externalSourceGUID, this.externalSourceName, schemaAttributeGUID, null, effectiveTime, this.forLineage, false);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.findSchemaAttributes(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<SchemaAttributeElement> getNestedSchemaAttributes(String parentSchemaElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getNestedSchemaAttributes(this.userId, this.externalSourceGUID, this.externalSourceName, parentSchemaElementGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaAttributesByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String schemaAttributeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getSchemaAttributeByGUID(this.userId, this.externalSourceGUID, this.externalSourceName, schemaAttributeGUID, effectiveTime, this.forLineage, false);
    }

    public String createProcess(boolean assetManagerIsHome, ProcessStatus processStatus, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.createProcess(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, null, processStatus, processProperties);
    }

    public String createProcessFromTemplate(boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.createProcessFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, templateGUID, null, templateProperties);
    }

    public void updateProcess(String processGUID, boolean isMergeUpdate, ProcessProperties processProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateProcess(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, null, isMergeUpdate, processProperties, effectiveTime, this.forLineage, false);
    }

    public void updateProcessStatus(String processGUID, ProcessStatus processStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateProcessStatus(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, null, processStatus, effectiveTime, this.forLineage, false);
    }

    @Deprecated
    public void setupProcessParent(String userId, String externalSourceGUID, String externalSourceName, boolean assetManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentProperties containmentProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.setupProcessParent(assetManagerIsHome, parentProcessGUID, childProcessGUID, containmentProperties, effectiveTime);
    }

    public void setupProcessParent(boolean assetManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentProperties containmentProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupProcessParent(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, parentProcessGUID, childProcessGUID, containmentProperties, effectiveTime, this.forLineage, false);
    }

    public void clearProcessParent(String parentProcessGUID, String childProcessGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearProcessParent(this.userId, this.externalSourceGUID, this.externalSourceName, parentProcessGUID, childProcessGUID, effectiveTime, this.forLineage, false);
    }

    public void publishProcess(String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.publishProcess(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, effectiveTime, this.forLineage, false);
    }

    public void withdrawProcess(String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.withdrawProcess(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, effectiveTime, this.forLineage, false);
    }

    public void removeProcess(String processGUID, String processExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.removeProcess(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, processExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public List<ProcessElement> findProcesses(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.findProcesses(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ProcessElement> getProcessesForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessesForAssetManager(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ProcessElement> getProcessesByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessesByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public ProcessElement getProcessByGUID(String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessByGUID(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, effectiveTime, this.forLineage, false);
    }

    public ProcessElement getProcessParent(String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessParent(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, effectiveTime, this.forLineage, false);
    }

    public List<ProcessElement> getSubProcesses(String processGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getSubProcesses(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public String createPort(boolean assetManagerIsHome, String processGUID, PortProperties portProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.createPort(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, processGUID, null, portProperties, effectiveTime, this.forLineage, false);
    }

    public void updatePort(String portGUID, PortProperties portProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updatePort(this.userId, this.externalSourceGUID, this.externalSourceName, portGUID, null, portProperties, effectiveTime, this.forLineage, false);
    }

    public void setupProcessPort(boolean assetManagerIsHome, String processGUID, String portGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupProcessPort(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, processGUID, portGUID, effectiveTime, this.forLineage, false);
    }

    public void clearProcessPort(String processGUID, String portGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearProcessPort(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, portGUID, effectiveTime, this.forLineage, false);
    }

    public void setupPortDelegation(boolean assetManagerIsHome, String portOneGUID, String portTwoGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupPortDelegation(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, portOneGUID, portTwoGUID, effectiveTime, this.forLineage, false);
    }

    public void clearPortDelegation(String portOneGUID, String portTwoGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearPortDelegation(this.userId, this.externalSourceGUID, this.externalSourceName, portOneGUID, portTwoGUID, effectiveTime, this.forLineage, false);
    }

    public void setupPortSchemaType(boolean assetManagerIsHome, String portGUID, String schemaTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupPortSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, portGUID, schemaTypeGUID, effectiveTime, this.forLineage, false);
    }

    public void clearPortSchemaType(String portGUID, String schemaTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearPortSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, portGUID, schemaTypeGUID, effectiveTime, this.forLineage, false);
    }

    public void removePort(String portGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.removePort(this.userId, this.externalSourceGUID, this.externalSourceName, portGUID, null, effectiveTime, this.forLineage, false);
    }

    public List<PortElement> findPorts(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.findPorts(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<PortElement> getPortsForProcess(String processGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortsForProcess(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<PortElement> getPortUse(String portGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortUse(this.userId, this.externalSourceGUID, this.externalSourceName, portGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public PortElement getPortDelegation(String portGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortDelegation(this.userId, this.externalSourceGUID, this.externalSourceName, portGUID, effectiveTime, this.forLineage, false);
    }

    public List<PortElement> getPortsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortsByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public PortElement getPortByGUID(String portGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortByGUID(this.userId, this.externalSourceGUID, this.externalSourceName, portGUID, effectiveTime, this.forLineage, false);
    }

    public void setBusinessSignificant(String elementGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setBusinessSignificant(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, null, effectiveTime, this.forLineage, false);
    }

    public void clearBusinessSignificant(String elementGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearBusinessSignificant(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, null, effectiveTime, this.forLineage, false);
    }

    public String setupDataFlow(boolean assetManagerIsHome, String dataSupplierGUID, String dataConsumerGUID, DataFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.setupDataFlow(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, dataSupplierGUID, dataConsumerGUID, properties, effectiveTime, this.forLineage, false);
    }

    public DataFlowElement getDataFlow(String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlow(this.userId, this.externalSourceGUID, this.externalSourceName, dataSupplierGUID, dataConsumerGUID, qualifiedName, effectiveTime, this.forLineage, false);
    }

    public void updateDataFlow(String dataFlowGUID, DataFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateDataFlow(this.userId, this.externalSourceGUID, this.externalSourceName, dataFlowGUID, properties, effectiveTime, this.forLineage, false);
    }

    public void clearDataFlow(String dataFlowGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearDataFlow(this.userId, this.externalSourceGUID, this.externalSourceName, dataFlowGUID, effectiveTime, this.forLineage, false);
    }

    public List<DataFlowElement> getDataFlowConsumers(String dataSupplierGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlowConsumers(this.userId, this.externalSourceGUID, this.externalSourceName, dataSupplierGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<DataFlowElement> getDataFlowSuppliers(String dataConsumerGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlowSuppliers(this.userId, this.externalSourceGUID, this.externalSourceName, dataConsumerGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public String setupControlFlow(boolean assetManagerIsHome, String currentStepGUID, String nextStepGUID, ControlFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.setupControlFlow(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, currentStepGUID, nextStepGUID, properties, effectiveTime, this.forLineage, false);
    }

    public ControlFlowElement getControlFlow(String currentStepGUID, String nextStepGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlow(this.userId, this.externalSourceGUID, this.externalSourceName, currentStepGUID, nextStepGUID, qualifiedName, effectiveTime, this.forLineage, false);
    }

    public void updateControlFlow(String controlFlowGUID, ControlFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateControlFlow(this.userId, this.externalSourceGUID, this.externalSourceName, controlFlowGUID, properties, effectiveTime, this.forLineage, false);
    }

    public void clearControlFlow(String controlFlowGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearControlFlow(this.userId, this.externalSourceGUID, this.externalSourceName, controlFlowGUID, effectiveTime, this.forLineage, false);
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String currentStepGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlowNextSteps(this.userId, this.externalSourceGUID, this.externalSourceName, currentStepGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String currentStepGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlowPreviousSteps(this.userId, this.externalSourceGUID, this.externalSourceName, currentStepGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public String setupProcessCall(boolean assetManagerIsHome, String callerGUID, String calledGUID, ProcessCallProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.setupProcessCall(this.userId, this.externalSourceGUID, this.externalSourceName, assetManagerIsHome, callerGUID, calledGUID, properties, effectiveTime, this.forLineage, false);
    }

    public ProcessCallElement getProcessCall(String callerGUID, String calledGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCall(this.userId, this.externalSourceGUID, this.externalSourceName, callerGUID, calledGUID, qualifiedName, effectiveTime, this.forLineage, false);
    }

    public void updateProcessCall(String processCallGUID, ProcessCallProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateProcessCall(this.userId, this.externalSourceGUID, this.externalSourceName, processCallGUID, properties, effectiveTime, this.forLineage, false);
    }

    public void clearProcessCall(String processCallGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearProcessCall(this.userId, this.externalSourceGUID, this.externalSourceName, processCallGUID, effectiveTime, this.forLineage, false);
    }

    public List<ProcessCallElement> getProcessCalled(String callerGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCalled(this.userId, this.externalSourceGUID, this.externalSourceName, callerGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ProcessCallElement> getProcessCallers(String calledGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCallers(this.userId, this.externalSourceGUID, this.externalSourceName, calledGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public void setupLineageMapping(String sourceElementGUID, String destinationElementGUID, LineageMappingProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.setupLineageMapping(this.userId, this.externalSourceGUID, this.externalSourceName, sourceElementGUID, destinationElementGUID, properties, effectiveTime, this.forLineage, false);
    }

    public void updateLineageMapping(String lineageMappingGUID, LineageMappingProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.updateLineageMapping(this.userId, this.externalSourceGUID, this.externalSourceName, lineageMappingGUID, properties, effectiveTime, this.forLineage, false);
    }

    public void clearLineageMapping(String lineageMappingGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearLineageMapping(this.userId, this.externalSourceGUID, this.externalSourceName, lineageMappingGUID, effectiveTime, this.forLineage, false);
    }

    public List<LineageMappingElement> getDestinationLineageMappings(String sourceElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDestinationLineageMappings(this.userId, this.externalSourceGUID, this.externalSourceName, sourceElementGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<LineageMappingElement> getSourceLineageMappings(String destinationElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getSourceLineageMappings(this.userId, this.externalSourceGUID, this.externalSourceName, destinationElementGUID, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public void addMementoClassification(String elementGUID, String elementExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.addMementoClassification(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, elementExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public void clearMementoClassification(String elementGUID, String elementExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearMementoClassification(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, elementExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public void addIncompleteClassification(String elementGUID, String elementExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.addIncompleteClassification(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, elementExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public void clearIncompleteClassification(String elementGUID, String elementExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.lineageExchangeClient.clearIncompleteClassification(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, elementExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public List<GovernanceActionProcessElement> findGovernanceActionProcesses(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.findGovernanceActionProcesses(this.userId, searchString, startFrom, pageSize);
    }

    public List<GovernanceActionProcessElement> getGovernanceActionProcessesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActionProcessesByName(this.userId, name, startFrom, pageSize);
    }

    public GovernanceActionProcessElement getGovernanceActionProcessByGUID(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActionProcessByGUID(this.userId, processGUID);
    }

    public List<GovernanceActionTypeElement> findGovernanceActionTypes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.findGovernanceActionTypes(this.userId, searchString, startFrom, pageSize);
    }

    public List<GovernanceActionTypeElement> getGovernanceActionTypesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActionTypesByName(this.userId, name, startFrom, pageSize);
    }

    public GovernanceActionTypeElement getGovernanceActionTypeByGUID(String actionTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActionTypeByGUID(this.userId, actionTypeGUID);
    }

    public GovernanceActionTypeElement getFirstActionType(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getFirstActionType(this.userId, processGUID);
    }

    public List<NextGovernanceActionTypeElement> getNextGovernanceActionTypes(String actionTypeGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getNextGovernanceActionTypes(this.userId, actionTypeGUID, startFrom, pageSize);
    }

    public GovernanceActionElement getGovernanceAction(String governanceActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceAction(this.userId, governanceActionGUID);
    }

    public List<GovernanceActionElement> getGovernanceActions(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getGovernanceActions(this.userId, startFrom, pageSize);
    }

    public List<GovernanceActionElement> getActiveGovernanceActions(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceExchangeClient.getActiveGovernanceActions(this.userId, startFrom, pageSize);
    }
}

