/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.lineage.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum LineageIntegratorAuditCode implements AuditLogMessageSet
{
    CONTEXT_INITIALIZING("OMIS-LINEAGE-INTEGRATOR-0001", AuditLogRecordSeverityLevel.STARTUP, "The lineage integrator context manager is being initialized for calls to server {0} on platform {1}", "The Lineage Integrator OMIS is initializing its context manager.", "Verify that the start up sequence goes on to initialize the context for each connector configured for this service."),
    CONNECTOR_CONTEXT_INITIALIZING("OMIS-LINEAGE-INTEGRATOR-0002", AuditLogRecordSeverityLevel.STARTUP, "Creating context for integration connector {0} ({1}) connecting to third party technology {2} with permitted synchronization of {3} and service options of {4}", "A new context is created for an integration connector.  This acts as a client to the open metadata repositories enabling the integration connector to synchronize open metadata with the third party technology's metadata", "Verify that this connector is being started with the correct configuration."),
    PERMITTED_SYNCHRONIZATION("OMIS-LINEAGE-INTEGRATOR-0003", AuditLogRecordSeverityLevel.STARTUP, "The context for connector {0} has its permitted synchronization set to {1}", "The context is set up to ensure that the connector can only issue requests that support the permitted synchronization.  If the connector issues requests that are not permitted it is returned UserNotAuthorizedExceptions.", "Check that this permitted synchronized value is as expected.  If it is not,change the configuration for this connector and restart the integration daemon."),
    NULL_CONTEXT("OMIS-LINEAGE-INTEGRATOR-0004", AuditLogRecordSeverityLevel.ERROR, "Integration connector {0} has a null context", "The integration connector is running but does not have a context.  This is a timing issue in the integration daemon.", "Gather information about the connector's configuration, the types of metadata it was integrating, the audit log messages from the integration daemon and its partner metadata server.  Then contact the Egeria community to get help."),
    OPEN_LINEAGE_FORMAT_ERROR("OMIS-LINEAGE-INTEGRATOR-0005", AuditLogRecordSeverityLevel.ERROR, "A {0} exception with message {1} occurred when parsing open lineage event: {2}", "The Lineage Integrator OMIS is unable to parse an incoming open lineage event into Egeria's OpenLineageRunEvent bean.  This may be due to either (1) an invalid open lineage event, or (2) Egeria's OpenLineageRunEvent not supporting an advancement in the open lineage standard.  The raw event is passed to the listening connectors with a null OpenLineageRunEvent bean.  The connector can use the open lineage standard server to process the event facet by facet.", "Verify the format of the open lineage event.  If incorrect, seek the source of the event.  If correct, look to enhance Egeria's OpenLineageRunEvent."),
    OPEN_LINEAGE_PUBLISH_ERROR("OMIS-LINEAGE-INTEGRATOR-0006", AuditLogRecordSeverityLevel.EXCEPTION, "A {0} exception with message {1} occurred when a listening integration connector tried to push an OpenLineage event", "The Lineage Integrator OMIS has caught the exception and will continue to pass the event to the remaining listening integration connectors.", "Look at the resulting stack trace to understand what went wrong in the called integration connector.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private LineageIntegratorAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "AuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

