/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.lineage.client;

import io.openlineage.client.OpenLineage;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.lineage.api.LineageIntegratorAPI;

public class LineageIntegrator
implements LineageIntegratorAPI {
    private final FFDCRESTClient restClient;
    private final String serverName;
    private final String serverPlatformRootURL;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public LineageIntegrator(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new FFDCRESTClient(serverName, serverPlatformRootURL, auditLog);
    }

    public LineageIntegrator(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new FFDCRESTClient(serverName, serverPlatformRootURL);
    }

    public LineageIntegrator(String serverName, String serverPlatformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new FFDCRESTClient(serverName, serverPlatformRootURL, userId, password, auditLog);
    }

    public LineageIntegrator(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new FFDCRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public ConnectorReport validateConnector(String userId, String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateConnector";
        String nameParameter = "connectorProviderClassName";
        String urlTemplate = "/servers/{0}/open-metadata/integration-services/lineage-integrator/users/{1}/validate-connector";
        this.invalidParameterHandler.validateUserId(userId, "validateConnector");
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "validateConnector");
        ConnectorReportResponse restResult = this.restClient.callOCFConnectorReportGetRESTCall("validateConnector", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-services/lineage-integrator/users/{1}/validate-connector", new Object[]{this.serverName, userId, connectorProviderClassName});
        return restResult.getConnectorReport();
    }

    public void publishOpenLineageEvent(String userId, OpenLineage.RunEvent event) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishOpenLineageEvent";
        String eventParameter = "event";
        String urlTemplate = "/servers/{0}/open-metadata/integration-services/lineage-integrator/users/{1}/publish-lineage-warehouse-event";
        this.invalidParameterHandler.validateUserId(userId, "publishOpenLineageEvent");
        this.invalidParameterHandler.validateObject((Object)event, "event", "publishOpenLineageEvent");
        this.restClient.callVoidPostRESTCall("publishOpenLineageEvent", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-services/lineage-integrator/users/{1}/publish-lineage-warehouse-event", (Object)event, new Object[]{this.serverName, userId});
    }
}

