/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.lineage.contextmanager;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExternalAssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GovernanceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorConnector;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorContext;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageEventListener;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageListenerManager;
import org.odpi.openmetadata.integrationservices.lineage.ffdc.LineageIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.lineage.ffdc.LineageIntegratorErrorCode;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;

public class LineageIntegratorContextManager
extends IntegrationContextManager
implements OpenLineageListenerManager {
    private ExternalAssetManagerClient assetManagerClient;
    private DataAssetExchangeClient dataAssetExchangeClient;
    private LineageExchangeClient lineageExchangeClient;
    private GovernanceExchangeClient governanceExchangeClient;
    private ObjectMapper objectMapper = new ObjectMapper();
    private List<OpenLineageEventListener> registeredEventListeners = new ArrayList<OpenLineageEventListener>();

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", LineageIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        AssetManagerRESTClient restClient = this.localServerPassword == null ? new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.assetManagerClient = new ExternalAssetManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.dataAssetExchangeClient = new DataAssetExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.lineageExchangeClient = new LineageExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.governanceExchangeClient = new GovernanceExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataSourceQualifiedNameParameterName = "metadataSourceQualifiedName";
        String methodName = "setUpMetadataSource";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateName(metadataSourceQualifiedName, "metadataSourceQualifiedName", "setUpMetadataSource");
        String metadataSourceGUID = this.assetManagerClient.getExternalAssetManagerGUID(this.localServerUserId, metadataSourceQualifiedName);
        if (metadataSourceGUID == null) {
            AssetManagerProperties properties = new AssetManagerProperties();
            properties.setQualifiedName(metadataSourceQualifiedName);
            metadataSourceGUID = this.assetManagerClient.createExternalAssetManager(this.localServerUserId, properties);
        }
        return metadataSourceGUID;
    }

    public void setContext(String connectorId, String connectorName, String metadataSourceQualifiedName, IntegrationConnector integrationConnector, PermittedSynchronization permittedSynchronization) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (!(integrationConnector instanceof LineageIntegratorConnector)) {
            String parameterName = "integrationConnector";
            throw new InvalidParameterException(LineageIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.LINEAGE_INTEGRATOR_OMIS.getIntegrationServiceFullName(), LineageIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
        }
        this.auditLog.logMessage("setContext", LineageIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
        AssetManagerEventClient eventClient = new AssetManagerEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.maxPageSize, this.auditLog, connectorId);
        LineageIntegratorConnector serviceSpecificConnector = (LineageIntegratorConnector)integrationConnector;
        String metadataSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
        serviceSpecificConnector.setContext(new LineageIntegratorContext((OpenLineageListenerManager)this, this.dataAssetExchangeClient, this.lineageExchangeClient, this.governanceExchangeClient, eventClient, this.localServerUserId, metadataSourceGUID, metadataSourceQualifiedName, connectorName, IntegrationServiceDescription.LINEAGE_INTEGRATOR_OMIS.getIntegrationServiceFullName(), this.auditLog));
    }

    public synchronized void registerListener(OpenLineageEventListener listener) {
        this.registeredEventListeners.add(listener);
    }

    public synchronized void publishOpenLineageRunEvent(String rawEvent) {
        String methodName = "publishOpenLineageRunEvent(rawEvent)";
        OpenLineageRunEvent event = null;
        if (rawEvent != null) {
            try {
                event = (OpenLineageRunEvent)this.objectMapper.readValue(rawEvent, OpenLineageRunEvent.class);
            }
            catch (Exception error) {
                this.auditLog.logException("publishOpenLineageRunEvent(rawEvent)", LineageIntegratorAuditCode.OPEN_LINEAGE_FORMAT_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage(), rawEvent}), rawEvent, (Throwable)error);
            }
        }
        this.publishToListeners(event, rawEvent, "publishOpenLineageRunEvent(rawEvent)");
    }

    public synchronized void publishOpenLineageRunEvent(OpenLineageRunEvent event) {
        String methodName = "publishOpenLineageRunEvent(event)";
        String rawEvent = null;
        if (event != null) {
            try {
                rawEvent = this.objectMapper.writeValueAsString((Object)event);
            }
            catch (Exception error) {
                this.auditLog.logException("publishOpenLineageRunEvent(event)", LineageIntegratorAuditCode.OPEN_LINEAGE_FORMAT_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage(), event.toString()}), event.toString(), (Throwable)error);
            }
        }
        this.publishToListeners(event, rawEvent, "publishOpenLineageRunEvent(event)");
    }

    private void publishToListeners(OpenLineageRunEvent event, String rawEvent, String methodName) {
        for (OpenLineageEventListener listener : this.registeredEventListeners) {
            if (listener == null) continue;
            try {
                listener.processOpenLineageRunEvent(event, rawEvent);
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, LineageIntegratorAuditCode.OPEN_LINEAGE_PUBLISH_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}), rawEvent, (Throwable)error);
            }
        }
    }
}

