/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.lineage.contextmanager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.OpenGovernanceClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GovernanceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorConnector;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorContext;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageEventListener;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageListenerManager;
import org.odpi.openmetadata.integrationservices.lineage.ffdc.LineageIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.lineage.ffdc.LineageIntegratorErrorCode;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;

public class LineageIntegratorContextManager
extends IntegrationContextManager
implements OpenLineageListenerManager {
    private DataAssetExchangeClient dataAssetExchangeClient;
    private LineageExchangeClient lineageExchangeClient;
    private GovernanceExchangeClient governanceExchangeClient;
    private OpenGovernanceClient openGovernanceClient;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.reader();
    private final List<OpenLineageEventListener> registeredEventListeners = new ArrayList<OpenLineageEventListener>();

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", LineageIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients(int maxPageSize) throws InvalidParameterException {
        this.openIntegrationClient = new OpenIntegrationServiceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.actionControlInterface = new OpenGovernanceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.openGovernanceClient = new OpenGovernanceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.governanceConfiguration = new GovernanceConfigurationClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        AssetManagerRESTClient restClient = this.localServerPassword == null ? new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.dataAssetExchangeClient = new DataAssetExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.lineageExchangeClient = new LineageExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.governanceExchangeClient = new GovernanceExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
    }

    public IntegrationContext setContext(String connectorId, String connectorName, String connectorUserId, IntegrationConnector integrationConnector, String integrationConnectorGUID, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (integrationConnector instanceof LineageIntegratorConnector) {
            LineageIntegratorConnector serviceSpecificConnector = (LineageIntegratorConnector)integrationConnector;
            this.auditLog.logMessage("setContext", LineageIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
            String externalSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName, null, null, null);
            String externalSourceName = metadataSourceQualifiedName;
            if (externalSourceGUID == null) {
                externalSourceName = null;
            }
            AssetManagerEventClient eventClient = new AssetManagerEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.maxPageSize, this.auditLog, connectorId);
            LineageIntegratorContext integratorContext = new LineageIntegratorContext(connectorId, connectorName, connectorUserId, this.partnerOMASServerName, this.openIntegrationClient, this.governanceConfiguration, this.openMetadataStoreClient, this.actionControlInterface, this.openGovernanceClient, (OpenLineageListenerManager)this, this.dataAssetExchangeClient, this.lineageExchangeClient, this.governanceExchangeClient, eventClient, generateIntegrationReport, permittedSynchronization, integrationConnectorGUID, externalSourceGUID, externalSourceName, IntegrationServiceDescription.LINEAGE_INTEGRATOR_OMIS.getIntegrationServiceFullName(), this.maxPageSize, this.auditLog);
            serviceSpecificConnector.setContext(integratorContext);
            integrationConnector.setConnectorName(connectorName);
            return integratorContext;
        }
        String parameterName = "integrationConnector";
        throw new InvalidParameterException(LineageIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.LINEAGE_INTEGRATOR_OMIS.getIntegrationServiceFullName(), LineageIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
    }

    public synchronized void registerListener(OpenLineageEventListener listener) {
        this.registeredEventListeners.add(listener);
    }

    public synchronized void publishOpenLineageRunEvent(String rawEvent) {
        String methodName = "publishOpenLineageRunEvent(rawEvent)";
        OpenLineageRunEvent event = null;
        if (rawEvent != null) {
            try {
                event = (OpenLineageRunEvent)OBJECT_READER.readValue(rawEvent, OpenLineageRunEvent.class);
            }
            catch (Exception error) {
                this.auditLog.logException("publishOpenLineageRunEvent(rawEvent)", LineageIntegratorAuditCode.OPEN_LINEAGE_FORMAT_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage(), rawEvent}), rawEvent, (Throwable)error);
            }
        }
        this.publishToListeners(event, rawEvent, "publishOpenLineageRunEvent(rawEvent)");
    }

    public synchronized void publishOpenLineageRunEvent(OpenLineageRunEvent event) {
        String methodName = "publishOpenLineageRunEvent(event)";
        String rawEvent = null;
        if (event != null) {
            try {
                rawEvent = OBJECT_WRITER.writeValueAsString((Object)event);
            }
            catch (Exception error) {
                this.auditLog.logException("publishOpenLineageRunEvent(event)", LineageIntegratorAuditCode.OPEN_LINEAGE_FORMAT_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage(), event.toString()}), event.toString(), (Throwable)error);
            }
        }
        this.publishToListeners(event, rawEvent, "publishOpenLineageRunEvent(event)");
    }

    private void publishToListeners(OpenLineageRunEvent event, String rawEvent, String methodName) {
        for (OpenLineageEventListener listener : this.registeredEventListeners) {
            if (listener == null) continue;
            try {
                listener.processOpenLineageRunEvent(event, rawEvent);
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, LineageIntegratorAuditCode.OPEN_LINEAGE_PUBLISH_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}), rawEvent, (Throwable)error);
            }
        }
    }
}

