/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.lineage.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.integrationservices.lineage.rest.LineageIntegratorRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/integration-services/lineage-integrator/users/{userId}"})
@Tag(name="Lineage Integrator OMIS", description="Supports the detection and creation of metadata for file systems and file servers.", externalDocs=@ExternalDocumentation(description="Lineage Integrator Open Metadata Integration Service (OMIS)", url="https://egeria-project.org/services/omis/lineage-integrator/overview/"))
public class LineageIntegratorResource {
    private LineageIntegratorRESTServices restAPI = new LineageIntegratorRESTServices();

    @GetMapping(path={"/validate-connector/{connectorProviderClassName}"})
    public ConnectorReportResponse validateConnector(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorProviderClassName) {
        return this.restAPI.validateConnector(serverName, userId, connectorProviderClassName);
    }

    @PostMapping(path={"/api/v1/lineage"})
    void publishOpenLineageEvent(@PathVariable String serverName, @PathVariable String userId, @RequestBody String event) {
        this.restAPI.publishOpenLineageEvent(serverName, userId, event);
    }
}

