/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.mermaid;

import java.util.ArrayList;
import org.odpi.openmetadata.commonservices.mermaid.MermaidGraphBuilderBase;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public class AssetGraphMermaidGraphBuilder
extends MermaidGraphBuilderBase {
    public AssetGraphMermaidGraphBuilder(AssetGraph assetGraph) {
        this.mermaidGraph.append("---\n");
        this.mermaidGraph.append("title: Asset - ");
        this.mermaidGraph.append(assetGraph.getProperties().getDisplayName());
        this.mermaidGraph.append(" [");
        this.mermaidGraph.append(assetGraph.getElementHeader().getGUID());
        this.mermaidGraph.append("]\n---\nflowchart LR\n%%{init: {\"flowchart\": {\"htmlLabels\": false}} }%%\n\n");
        ArrayList<String> usedNodeNames = new ArrayList<String>();
        String currentNodeName = assetGraph.getElementHeader().getGUID();
        String currentDisplayName = assetGraph.getProperties().getDisplayName();
        this.appendMermaidNode(currentNodeName, currentDisplayName, assetGraph.getElementHeader().getType().getTypeName());
        usedNodeNames.add(currentNodeName);
        if (assetGraph.getAnchoredElements() != null) {
            for (MetadataElementSummary node : assetGraph.getAnchoredElements()) {
                if (node == null) continue;
                currentNodeName = node.getElementHeader().getGUID();
                currentDisplayName = (String)node.getProperties().get(OpenMetadataProperty.DISPLAY_NAME.name);
                if (currentDisplayName == null) {
                    currentDisplayName = (String)node.getProperties().get(OpenMetadataProperty.NAME.name);
                }
                if (currentDisplayName == null) {
                    currentDisplayName = (String)node.getProperties().get(OpenMetadataProperty.RESOURCE_NAME.name);
                }
                if (currentDisplayName == null) {
                    currentDisplayName = (String)node.getProperties().get(OpenMetadataProperty.QUALIFIED_NAME.name);
                }
                if (usedNodeNames.contains(currentNodeName)) continue;
                this.appendMermaidNode(currentNodeName, currentDisplayName, node.getElementHeader().getType().getTypeName());
                usedNodeNames.add(currentNodeName);
            }
            for (MetadataRelationship line : assetGraph.getRelationships()) {
                if (line == null) continue;
                super.appendMermaidLine(this.removeSpaces(line.getEnd1().getGUID()), line.getType().getTypeName(), this.removeSpaces(line.getEnd2().getGUID()));
            }
        }
    }
}

