/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.mermaid;

import java.util.ArrayList;
import org.odpi.openmetadata.commonservices.mermaid.MermaidGraphBuilderBase;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetLineageGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetLineageGraphNode;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetLineageGraphRelationship;

public class AssetLineageGraphMermaidGraphBuilder
extends MermaidGraphBuilderBase {
    public AssetLineageGraphMermaidGraphBuilder(AssetLineageGraph assetLineageGraph) {
        this.mermaidGraph.append("---\n");
        this.mermaidGraph.append("title: Lineage Graph for Asset - ");
        this.mermaidGraph.append(assetLineageGraph.getProperties().getDisplayName());
        this.mermaidGraph.append(" [");
        this.mermaidGraph.append(assetLineageGraph.getElementHeader().getGUID());
        this.mermaidGraph.append("]\n---\nflowchart TD\n%%{init: {\"flowchart\": {\"htmlLabels\": false}} }%%\n\n");
        ArrayList<String> usedNodeNames = new ArrayList<String>();
        String currentNodeName = assetLineageGraph.getElementHeader().getGUID();
        String currentDisplayName = assetLineageGraph.getProperties().getDisplayName();
        this.appendMermaidNode(currentNodeName, currentDisplayName, assetLineageGraph.getElementHeader().getType().getTypeName());
        usedNodeNames.add(currentNodeName);
        if (assetLineageGraph.getLinkedAssets() != null) {
            for (AssetLineageGraphNode node : assetLineageGraph.getLinkedAssets()) {
                if (node == null) continue;
                currentNodeName = node.getElementHeader().getGUID();
                currentDisplayName = node.getProperties().getDisplayName();
                if (currentDisplayName == null) {
                    currentDisplayName = node.getProperties().getName();
                }
                if (currentDisplayName == null) {
                    currentDisplayName = node.getProperties().getResourceName();
                }
                if (currentDisplayName == null) {
                    currentDisplayName = node.getProperties().getQualifiedName();
                }
                if (usedNodeNames.contains(currentNodeName)) continue;
                this.appendMermaidNode(currentNodeName, currentDisplayName, node.getElementHeader().getType().getTypeName());
                usedNodeNames.add(currentNodeName);
            }
            for (AssetLineageGraphRelationship line : assetLineageGraph.getLineageRelationships()) {
                if (line == null) continue;
                super.appendMermaidLine(line.getEnd1AssetGUID(), this.getListLabel(line.getRelationshipTypes()), line.getEnd2AssetGUID());
            }
        }
    }
}

