/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.mermaid;

import java.util.List;

public class MermaidGraphBuilderBase {
    protected final StringBuilder mermaidGraph = new StringBuilder();

    public String getListLabel(List<String> labelValues) {
        if (labelValues != null) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean firstValue = true;
            for (String labelValue : labelValues) {
                if (!firstValue) {
                    stringBuilder.append(",\n");
                }
                firstValue = false;
                stringBuilder.append(labelValue);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public void appendMermaidNode(String currentNodeName, String currentDisplayName, String currentType) {
        this.mermaidGraph.append(this.removeSpaces(currentNodeName));
        this.mermaidGraph.append("(\"`*");
        this.mermaidGraph.append(currentType);
        this.mermaidGraph.append("*\n**");
        this.mermaidGraph.append(currentDisplayName);
        this.mermaidGraph.append("**`\")\n");
    }

    public void appendMermaidLine(String end1Id, String label, String end2Id) {
        this.mermaidGraph.append(this.removeSpaces(end1Id));
        if (label != null) {
            this.mermaidGraph.append("-->|\"");
            this.mermaidGraph.append(label);
            this.mermaidGraph.append("\"|");
        } else {
            this.mermaidGraph.append("-->");
        }
        this.mermaidGraph.append(this.removeSpaces(end2Id));
        this.mermaidGraph.append("\n");
    }

    String removeSpaces(String currentQualifiedName) {
        String noSpaces = currentQualifiedName.replaceAll("\\s+", "");
        return noSpaces.replaceAll("[\\[\\](){}]", "");
    }

    public String getMermaidGraph() {
        return this.mermaidGraph.toString();
    }
}

