/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.mermaid;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.mermaid.MermaidGraphBuilderBase;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElementGraph;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public class OpenMetadataMermaidGraphBuilder
extends MermaidGraphBuilderBase {
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final String serviceName = "Mermaid Graph Builder";

    public OpenMetadataMermaidGraphBuilder(OpenMetadataElementGraph elementGraph) {
        this.mermaidGraph.append("---\n");
        this.mermaidGraph.append("title: Anchor Element - ");
        this.mermaidGraph.append(this.getDisplayName(elementGraph.getElementProperties(), elementGraph.getType().getTypeName()));
        this.mermaidGraph.append(" [");
        this.mermaidGraph.append(elementGraph.getElementGUID());
        this.mermaidGraph.append("]\n---\nflowchart LR\n%%{init: {\"flowchart\": {\"htmlLabels\": false}} }%%\n\n");
        ArrayList<String> usedNodeNames = new ArrayList<String>();
        String currentNodeName = elementGraph.getElementGUID();
        String currentDisplayName = this.getDisplayName(elementGraph.getElementProperties(), elementGraph.getType().getTypeName());
        this.appendMermaidNode(currentNodeName, currentDisplayName, elementGraph.getType().getTypeName());
        usedNodeNames.add(currentNodeName);
        if (elementGraph.getAnchoredElements() != null) {
            for (OpenMetadataElement node : elementGraph.getAnchoredElements()) {
                if (node == null) continue;
                currentNodeName = node.getElementGUID();
                currentDisplayName = this.getDisplayName(node.getElementProperties(), node.getType().getTypeName());
                if (usedNodeNames.contains(currentNodeName)) continue;
                this.appendMermaidNode(currentNodeName, currentDisplayName, node.getType().getTypeName());
                usedNodeNames.add(currentNodeName);
            }
            for (OpenMetadataRelationship line : elementGraph.getRelationships()) {
                if (line == null) continue;
                this.mermaidGraph.append(this.removeSpaces(line.getElementGUIDAtEnd1()));
                this.mermaidGraph.append("-->|");
                this.mermaidGraph.append(line.getType().getTypeName());
                this.mermaidGraph.append("|");
                this.mermaidGraph.append(this.removeSpaces(line.getElementGUIDAtEnd2()));
                this.mermaidGraph.append("\n");
            }
        }
    }

    public OpenMetadataMermaidGraphBuilder(String elementGUID, List<RelatedMetadataElement> relatedMetadataElements) {
        this.mermaidGraph.append("---\n");
        this.mermaidGraph.append("title: Starting Element - ");
        this.mermaidGraph.append(elementGUID);
        this.mermaidGraph.append("\n---\nflowchart LR\n%%{init: {\"flowchart\": {\"htmlLabels\": false}} }%%\n\n");
        ArrayList<String> usedNodeNames = new ArrayList<String>();
        String currentNodeName = elementGUID;
        String currentDisplayName = elementGUID;
        this.appendMermaidNode(currentNodeName, currentDisplayName, "Starting from");
        usedNodeNames.add(currentNodeName);
        if (relatedMetadataElements != null) {
            for (RelatedMetadataElement node : relatedMetadataElements) {
                if (node == null) continue;
                currentNodeName = node.getElement().getElementGUID();
                currentDisplayName = this.getDisplayName(node.getElement().getElementProperties(), node.getElement().getType().getTypeName());
                if (usedNodeNames.contains(currentNodeName)) continue;
                this.appendMermaidNode(currentNodeName, currentDisplayName, node.getType().getTypeName());
                usedNodeNames.add(currentNodeName);
            }
            for (RelatedMetadataElement line : relatedMetadataElements) {
                if (line == null) continue;
                this.mermaidGraph.append(this.removeSpaces(elementGUID));
                this.mermaidGraph.append("-->|");
                this.mermaidGraph.append(line.getType().getTypeName());
                this.mermaidGraph.append("|");
                this.mermaidGraph.append(this.removeSpaces(line.getElement().getElementGUID()));
                this.mermaidGraph.append("\n");
            }
        }
    }

    public OpenMetadataMermaidGraphBuilder(String end1GUID, String end2GUID, List<OpenMetadataRelationship> openMetadataRelationships) {
        this.mermaidGraph.append("---\n");
        this.mermaidGraph.append("title: Relationships for Element - ");
        this.mermaidGraph.append(end1GUID);
        this.mermaidGraph.append(" - Linked to - ");
        this.mermaidGraph.append(end2GUID);
        this.mermaidGraph.append("]\n---\nflowchart LR\n%%{init: {\"flowchart\": {\"htmlLabels\": false}} }%%\n\n");
        ArrayList<String> usedNodeNames = new ArrayList<String>();
        if (openMetadataRelationships != null) {
            for (OpenMetadataRelationship node : openMetadataRelationships) {
                if (node == null) continue;
                String currentNodeName = node.getElementGUIDAtEnd1();
                String currentDisplayName = node.getElementAtEnd1().getUniqueName() != null ? node.getElementAtEnd1().getUniqueName() : node.getElementAtEnd1().getType().getTypeName();
                if (!usedNodeNames.contains(currentNodeName)) {
                    this.appendMermaidNode(currentNodeName, currentDisplayName, node.getType().getTypeName());
                    usedNodeNames.add(currentNodeName);
                }
                currentNodeName = node.getElementGUIDAtEnd2();
                currentDisplayName = node.getElementAtEnd2().getUniqueName() != null ? node.getElementAtEnd2().getUniqueName() : node.getElementAtEnd2().getType().getTypeName();
                if (usedNodeNames.contains(currentNodeName)) continue;
                this.appendMermaidNode(currentNodeName, currentDisplayName, node.getType().getTypeName());
                usedNodeNames.add(currentNodeName);
            }
            for (OpenMetadataRelationship line : openMetadataRelationships) {
                if (line == null) continue;
                this.mermaidGraph.append(this.removeSpaces(line.getElementGUIDAtEnd1()));
                this.mermaidGraph.append("-->|");
                this.mermaidGraph.append(line.getType().getTypeName());
                this.mermaidGraph.append("|");
                this.mermaidGraph.append(this.removeSpaces(line.getElementGUIDAtEnd2()));
                this.mermaidGraph.append("\n");
            }
        }
    }

    public OpenMetadataMermaidGraphBuilder(List<OpenMetadataRelationship> openMetadataRelationships) {
        this.mermaidGraph.append("---\n");
        this.mermaidGraph.append("title: Relationships matching Query");
        this.mermaidGraph.append("\n---\nflowchart LR\n%%{init: {\"flowchart\": {\"htmlLabels\": false}} }%%\n\n");
        ArrayList<String> usedNodeNames = new ArrayList<String>();
        if (openMetadataRelationships != null) {
            for (OpenMetadataRelationship node : openMetadataRelationships) {
                if (node == null) continue;
                String currentNodeName = node.getElementGUIDAtEnd1();
                String currentDisplayName = node.getElementAtEnd1().getUniqueName() != null ? node.getElementAtEnd1().getUniqueName() : node.getElementAtEnd1().getType().getTypeName();
                if (!usedNodeNames.contains(currentNodeName)) {
                    this.appendMermaidNode(currentNodeName, currentDisplayName, node.getType().getTypeName());
                    usedNodeNames.add(currentNodeName);
                }
                currentNodeName = node.getElementGUIDAtEnd2();
                currentDisplayName = node.getElementAtEnd2().getUniqueName() != null ? node.getElementAtEnd2().getUniqueName() : node.getElementAtEnd2().getType().getTypeName();
                if (usedNodeNames.contains(currentNodeName)) continue;
                this.appendMermaidNode(currentNodeName, currentDisplayName, node.getType().getTypeName());
                usedNodeNames.add(currentNodeName);
            }
            for (OpenMetadataRelationship line : openMetadataRelationships) {
                if (line == null) continue;
                this.mermaidGraph.append(this.removeSpaces(line.getElementGUIDAtEnd1()));
                this.mermaidGraph.append("-->|");
                this.mermaidGraph.append(line.getType().getTypeName());
                this.mermaidGraph.append("|");
                this.mermaidGraph.append(this.removeSpaces(line.getElementGUIDAtEnd2()));
                this.mermaidGraph.append("\n");
            }
        }
    }

    private String getDisplayName(ElementProperties elementProperties, String typeName) {
        String methodName = "getDisplayName";
        String currentDisplayName = this.propertyHelper.getStringProperty("Mermaid Graph Builder", OpenMetadataProperty.NAME.name, elementProperties, "getDisplayName");
        if (currentDisplayName == null) {
            currentDisplayName = this.propertyHelper.getStringProperty("Mermaid Graph Builder", OpenMetadataProperty.DISPLAY_NAME.name, elementProperties, "getDisplayName");
        }
        if (currentDisplayName == null) {
            currentDisplayName = this.propertyHelper.getStringProperty("Mermaid Graph Builder", OpenMetadataProperty.RESOURCE_NAME.name, elementProperties, "getDisplayName");
        }
        if (currentDisplayName == null) {
            currentDisplayName = this.propertyHelper.getStringProperty("Mermaid Graph Builder", OpenMetadataProperty.QUALIFIED_NAME.name, elementProperties, "getDisplayName");
        }
        if (currentDisplayName == null) {
            currentDisplayName = typeName;
        }
        return currentDisplayName;
    }
}

