/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.metadataexplorer.admin;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.ViewServerGenericServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.metadataexplorer.ffdc.MetadataExplorerAuditCode;
import org.odpi.openmetadata.viewservices.metadataexplorer.server.MetadataExplorerInstance;

public class MetadataExplorerAdmin
extends ViewServerGenericServiceAdmin {
    private AuditLog auditLog = null;
    private MetadataExplorerInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfig, AuditLog auditLog, String serverUserName, int maxPageSize, List<ViewServiceConfig> activeViewServices) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", MetadataExplorerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        this.serverName = serverName;
        try {
            this.instance = new MetadataExplorerInstance(serverName, auditLog, serverUserName, maxPageSize, viewServiceConfig.getOMAGServerName(), viewServiceConfig.getOMAGServerPlatformRootURL(), activeViewServices);
            auditLog.logMessage("initialize", MetadataExplorerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(), viewServiceConfig.toString());
        }
        catch (Exception error) {
            auditLog.logException("initialize", MetadataExplorerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(error.getMessage()), viewServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", ViewServiceDescription.METADATA_EXPLORER.getViewServiceFullName(), error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", MetadataExplorerAuditCode.SERVICE_TERMINATING.getMessageDefinition(this.serverName));
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", MetadataExplorerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.serverName));
    }
}

