/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.metadataexplorer.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.viewservices.metadataexplorer.ffdc.MetadataExplorerErrorCode;
import org.odpi.openmetadata.viewservices.metadataexplorer.handlers.OpenMetadataHandler;

public class MetadataExplorerInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.METADATA_EXPLORER;
    private final Map<String, OpenMetadataHandler> openMetadataHandlerMap = new HashMap<String, OpenMetadataHandler>();
    private final List<ViewServiceConfig> activeViewServices;

    public MetadataExplorerInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL, List<ViewServiceConfig> activeViewServices) {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.activeViewServices = activeViewServices;
    }

    public OpenMetadataHandler getOpenMetadataHandler(String viewServiceURLMarker, String methodName) throws InvalidParameterException {
        OpenMetadataHandler openMetadataHandler = null;
        if (viewServiceURLMarker != null && (openMetadataHandler = this.openMetadataHandlerMap.get(viewServiceURLMarker)) == null) {
            for (ViewServiceConfig viewServiceConfig : this.activeViewServices) {
                String viewServicePartnerService;
                if (!viewServiceConfig.getViewServiceURLMarker().equals(viewServiceURLMarker) || (viewServicePartnerService = viewServiceConfig.getViewServicePartnerService()) == null) continue;
                for (AccessServiceDescription accessServiceDescription : AccessServiceDescription.values()) {
                    if (!accessServiceDescription.getAccessServiceFullName().equals(viewServicePartnerService)) continue;
                    openMetadataHandler = new OpenMetadataHandler(accessServiceDescription.getAccessServiceURLMarker(), viewServiceConfig.getOMAGServerName(), viewServiceConfig.getOMAGServerPlatformRootURL(), this.maxPageSize);
                    this.openMetadataHandlerMap.put(viewServiceURLMarker, openMetadataHandler);
                }
            }
        }
        if (openMetadataHandler == null) {
            throw new InvalidParameterException(MetadataExplorerErrorCode.INVALID_URL_MARKER.getMessageDefinition(viewServiceURLMarker), ((Object)((Object)this)).getClass().getName(), methodName, "viewServiceURLMarker");
        }
        return openMetadataHandler;
    }
}

