/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.metadataexplorer.server;

import java.util.Date;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnchorSearchMatchesListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnchorSearchMatchesResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnyTimeRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.FindRelationshipRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.FindRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.HistoryRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataGraphResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataRelationshipListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataRelationshipResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.metadataexplorer.handlers.OpenMetadataHandler;
import org.odpi.openmetadata.viewservices.metadataexplorer.server.MetadataExplorerInstanceHandler;
import org.slf4j.LoggerFactory;

public class MetadataExplorerRESTServices
extends TokenController {
    private static final MetadataExplorerInstanceHandler instanceHandler = new MetadataExplorerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(MetadataExplorerRESTServices.class), instanceHandler.getServiceName());

    public OpenMetadataElementResponse getMetadataElementByGUID(String serverName, String elementGUID, String viewServiceURLMarker, AnyTimeRequestBody requestBody) {
        String methodName = "getMetadataElementByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMetadataElementByGUID");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMetadataElementByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByGUID");
            OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "getMetadataElementByGUID");
            if (requestBody != null) {
                response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getAsOfTime(), requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, false, false, null, new Date()));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMetadataElementByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementResponse getMetadataElementByUniqueName(String serverName, String viewServiceURLMarker, NameRequestBody requestBody) {
        String methodName = "getMetadataElementByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMetadataElementByUniqueName");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMetadataElementByUniqueName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByUniqueName");
            if (requestBody != null) {
                OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "getMetadataElementByUniqueName");
                response.setElement(handler.getMetadataElementByUniqueName(userId, requestBody.getName(), requestBody.getNamePropertyName(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getAsOfTime(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementByUniqueName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMetadataElementByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataElementGUIDByUniqueName(String serverName, String viewServiceURLMarker, NameRequestBody requestBody) {
        String methodName = "getMetadataElementGUIDByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMetadataElementGUIDByUniqueName");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMetadataElementGUIDByUniqueName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementGUIDByUniqueName");
            if (requestBody != null) {
                OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "getMetadataElementGUIDByUniqueName");
                response.setGUID(handler.getMetadataElementGUIDByUniqueName(userId, requestBody.getName(), requestBody.getNamePropertyName(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getAsOfTime(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementGUIDByUniqueName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMetadataElementGUIDByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse getMetadataElementHistory(String serverName, String elementGUID, String viewServiceURLMarker, int startFrom, int pageSize, boolean oldestFirst, HistoryRequestBody requestBody) {
        String methodName = "getMetadataElementHistory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMetadataElementHistory");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMetadataElementHistory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementHistory");
            OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "getMetadataElementHistory");
            if (requestBody != null) {
                response.setElementList(handler.getMetadataElementHistory(userId, elementGUID, requestBody.getFromTime(), requestBody.getToTime(), oldestFirst, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                response.setElementList(handler.getMetadataElementHistory(userId, elementGUID, null, null, oldestFirst, false, false, null, startFrom, pageSize));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMetadataElementHistory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElementsWithString(String serverName, String viewServiceURLMarker, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findMetadataElementsWithString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findMetadataElementsWithString");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findMetadataElementsWithString");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElementsWithString");
            if (requestBody != null) {
                OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "findMetadataElementsWithString");
                response.setElementList(handler.findMetadataElementsWithString(userId, requestBody.getSearchString(), requestBody.getTypeName(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findMetadataElementsWithString", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findMetadataElementsWithString", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnchorSearchMatchesResponse findElementsForAnchor(String serverName, String viewServiceURLMarker, String anchorGUID, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findElementsForAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findElementsForAnchor");
        AuditLog auditLog = null;
        AnchorSearchMatchesResponse response = new AnchorSearchMatchesResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findElementsForAnchor");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findElementsForAnchor");
            if (requestBody != null) {
                OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "findElementsForAnchor");
                response.setElement(handler.findElementsForAnchor(userId, requestBody.getSearchString(), anchorGUID, requestBody.getTypeName(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findElementsForAnchor", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findElementsForAnchor", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnchorSearchMatchesListResponse findElementsInAnchorDomain(String serverName, String viewServiceURLMarker, String anchorDomainName, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findElementsInAnchorDomain";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findElementsInAnchorDomain");
        AuditLog auditLog = null;
        AnchorSearchMatchesListResponse response = new AnchorSearchMatchesListResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findElementsInAnchorDomain");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findElementsInAnchorDomain");
            if (requestBody != null) {
                OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "findElementsInAnchorDomain");
                response.setElements(handler.findElementsInAnchorDomain(userId, requestBody.getSearchString(), anchorDomainName, requestBody.getTypeName(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findElementsInAnchorDomain", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findElementsInAnchorDomain", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnchorSearchMatchesListResponse findElementsInAnchorScope(String serverName, String viewServiceURLMarker, String anchorScopeGUID, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findElementsInAnchorScope";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findElementsInAnchorScope");
        AuditLog auditLog = null;
        AnchorSearchMatchesListResponse response = new AnchorSearchMatchesListResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findElementsInAnchorScope");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findElementsInAnchorScope");
            if (requestBody != null) {
                OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "findElementsInAnchorScope");
                response.setElements(handler.findElementsInAnchorScope(userId, requestBody.getSearchString(), anchorScopeGUID, requestBody.getTypeName(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findElementsInAnchorScope", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findElementsInAnchorScope", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementListResponse getRelatedMetadataElements(String serverName, String elementGUID, String relationshipTypeName, String viewServiceURLMarker, int startingAtEnd, int startFrom, int pageSize, ResultsRequestBody requestBody) {
        String methodName = "getRelatedMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getRelatedMetadataElements");
        AuditLog auditLog = null;
        RelatedMetadataElementListResponse response = new RelatedMetadataElementListResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getRelatedMetadataElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedMetadataElements");
            OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "getRelatedMetadataElements");
            if (requestBody != null) {
                response.setRelatedElementList(handler.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                response.setRelatedElementList(handler.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, null, startFrom, pageSize));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRelatedMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataGraphResponse getAnchoredElementsGraph(String serverName, String viewServiceURLMarker, String elementGUID, int startFrom, int pageSize, AnyTimeRequestBody requestBody) {
        String methodName = "getAnchoredElementsGraph";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getAnchoredElementsGraph");
        OpenMetadataGraphResponse response = new OpenMetadataGraphResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getAnchoredElementsGraph");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnchoredElementsGraph");
            OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "getAnchoredElementsGraph");
            if (requestBody != null) {
                response.setElementGraph(handler.getAnchoredElementsGraph(userId, elementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), startFrom, pageSize, requestBody.getAsOfTime(), requestBody.getEffectiveTime()));
            } else {
                response.setElementGraph(handler.getAnchoredElementsGraph(userId, elementGUID, false, false, startFrom, pageSize, null, new Date()));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAnchoredElementsGraph", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataRelationshipListResponse getMetadataElementRelationships(String serverName, String metadataElementAtEnd1GUID, String relationshipTypeName, String metadataElementAtEnd2GUID, String viewServiceURLMarker, int startFrom, int pageSize, ResultsRequestBody requestBody) {
        String methodName = "getMetadataElementRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMetadataElementRelationships");
        AuditLog auditLog = null;
        OpenMetadataRelationshipListResponse response = new OpenMetadataRelationshipListResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMetadataElementRelationships");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementRelationships");
            OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "getMetadataElementRelationships");
            if (requestBody != null) {
                response.setRelationshipList(handler.getMetadataElementRelationships(userId, metadataElementAtEnd1GUID, metadataElementAtEnd2GUID, relationshipTypeName, requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                response.setRelationshipList(handler.getMetadataElementRelationships(userId, metadataElementAtEnd1GUID, metadataElementAtEnd2GUID, relationshipTypeName, null, null, null, null, false, false, null, startFrom, pageSize));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMetadataElementRelationships", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElements(String serverName, String viewServiceURLMarker, int startFrom, int pageSize, FindRequestBody requestBody) {
        String methodName = "findMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findMetadataElements");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findMetadataElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElements");
            if (requestBody != null) {
                OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "findMetadataElements");
                response.setElementList(handler.findMetadataElements(userId, requestBody.getMetadataElementTypeName(), requestBody.getMetadataElementSubtypeNames(), requestBody.getSearchProperties(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getMatchClassifications(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findMetadataElements", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataRelationshipListResponse findRelationshipsBetweenMetadataElements(String serverName, String viewServiceURLMarker, int startFrom, int pageSize, FindRelationshipRequestBody requestBody) {
        String methodName = "findRelationshipsBetweenMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findRelationshipsBetweenMetadataElements");
        AuditLog auditLog = null;
        OpenMetadataRelationshipListResponse response = new OpenMetadataRelationshipListResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findRelationshipsBetweenMetadataElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findRelationshipsBetweenMetadataElements");
            if (requestBody != null) {
                OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "findRelationshipsBetweenMetadataElements");
                response.setRelationshipList(handler.findRelationshipsBetweenMetadataElements(userId, requestBody.getRelationshipTypeName(), requestBody.getSearchProperties(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findRelationshipsBetweenMetadataElements", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findRelationshipsBetweenMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataRelationshipResponse getRelationshipByGUID(String serverName, String relationshipGUID, String viewServiceURLMarker, AnyTimeRequestBody requestBody) {
        String methodName = "getRelationshipByGUID";
        String guidParameterName = "relationshipGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getRelationshipByGUID");
        AuditLog auditLog = null;
        OpenMetadataRelationshipResponse response = new OpenMetadataRelationshipResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getRelationshipByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelationshipByGUID");
            OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "getRelationshipByGUID");
            if (requestBody != null) {
                response.setElement(handler.getRelationshipByGUID(userId, relationshipGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getAsOfTime(), requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getRelationshipByGUID(userId, relationshipGUID, false, false, null, new Date()));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRelationshipByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataRelationshipListResponse getRelationshipHistory(String serverName, String relationshipGUID, String viewServiceURLMarker, int startFrom, int pageSize, boolean oldestFirst, HistoryRequestBody requestBody) {
        String methodName = "getRelationshipHistory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getRelationshipHistory");
        AuditLog auditLog = null;
        OpenMetadataRelationshipListResponse response = new OpenMetadataRelationshipListResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getRelationshipHistory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelationshipHistory");
            OpenMetadataHandler handler = instanceHandler.getOpenMetadataHandler(userId, serverName, viewServiceURLMarker, "getRelationshipHistory");
            if (requestBody != null) {
                response.setRelationshipList(handler.getRelationshipHistory(userId, relationshipGUID, requestBody.getFromTime(), requestBody.getToTime(), oldestFirst, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                response.setRelationshipList(handler.getRelationshipHistory(userId, relationshipGUID, null, null, oldestFirst, false, false, null, startFrom, pageSize));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRelationshipHistory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

