/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.metadataexplorer.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnchorSearchMatchesListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnchorSearchMatchesResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnyTimeRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.FindRelationshipRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.FindRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.HistoryRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataGraphResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataRelationshipListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataRelationshipResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.viewservices.metadataexplorer.server.MetadataExplorerRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/{urlMarker}"})
@Tag(name="API: Metadata Explorer OMVS", description="The Metadata Explorer OMVS provides APIs for supporting the search, query and retrieval of open metadata.  It is an advanced API for users that understand the [Open Metadata Types](https://egeria-project.org/types/).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
public class MetadataExplorerResource {
    private final MetadataExplorerRESTServices restAPI = new MetadataExplorerRESTServices();

    @PostMapping(path={"/metadata-elements/{elementGUID}"})
    @Operation(summary="getMetadataElementByGUID", description="Retrieve the metadata element using its unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataElementResponse getMetadataElementByGUID(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String urlMarker, @RequestBody(required=false) AnyTimeRequestBody requestBody) {
        return this.restAPI.getMetadataElementByGUID(serverName, elementGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/metadata-elements/by-unique-name"})
    @Operation(summary="getMetadataElementByUniqueName", description="Retrieve the metadata element using its unique name (typically the qualified name, but it is possible to specify a different property name in the request body as long as it is unique).  If multiple matching instances are found, and exception is thrown.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataElementResponse getMetadataElementByUniqueName(@PathVariable String serverName, @PathVariable String urlMarker, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementByUniqueName(serverName, urlMarker, requestBody);
    }

    @PostMapping(path={"/metadata-elements/guid-by-unique-name"})
    @Operation(summary="getMetadataElementGUIDByUniqueName", description="Retrieve the metadata element GUID using its unique name (typically the qualified name, but it is possible to specify a different property name in the request body as long as it is unique).  If multiple matching instances are found, and exception is thrown.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public GUIDResponse getMetadataElementGUIDByUniqueName(@PathVariable String serverName, @PathVariable String urlMarker, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementGUIDByUniqueName(serverName, urlMarker, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{elementGUID}/history"})
    @Operation(summary="getMetadataElementHistory", description="Retrieve all the versions of an element.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataElementsResponse getMetadataElementHistory(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean oldestFirst, @RequestBody(required=false) HistoryRequestBody requestBody) {
        return this.restAPI.getMetadataElementHistory(serverName, elementGUID, urlMarker, startFrom, pageSize, oldestFirst, requestBody);
    }

    @PostMapping(path={"/metadata-elements/by-search-string"})
    @Operation(summary="findMetadataElementsWithString", description="Retrieve the metadata elements that contain the requested string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataElementsResponse findMetadataElementsWithString(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findMetadataElementsWithString(serverName, urlMarker, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/metadata-elements/by-search-string/for-anchor/{anchorGUID}"})
    @Operation(summary="findElementsForAnchor", description="Return a list of elements with the requested search string in their (display, resource)name, qualified name, title, text, summary, identifier or description.  The search string is interpreted as a regular expression (RegEx).  The breadth of the search is determined by the supplied anchorGUID.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/anchor-management/overview/"))
    public AnchorSearchMatchesResponse findElementsForAnchor(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String anchorGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findElementsForAnchor(serverName, urlMarker, anchorGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/metadata-elements/by-search-string/in-anchor-domain/{anchorDomainName}"})
    @Operation(summary="findElementsInAnchorDomain", description="Return a list of elements with the requested search string in their (display, resource)name, qualified name, title, text, summary, identifier or description.  The search string is interpreted as a regular expression (RegEx).  The breadth of the search is determined by the supplied domain name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/anchor-management/overview/"))
    public AnchorSearchMatchesListResponse findElementsInAnchorDomain(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String anchorDomainName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findElementsInAnchorDomain(serverName, urlMarker, anchorDomainName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/metadata-elements/by-search-string/in-anchor-scope/{anchorScopeGUID}"})
    @Operation(summary="findElementsInAnchorScope", description="Return a list of elements with the requested search string in their (display, resource)name, qualified name, title, text, summary, identifier or description.  The search string is interpreted as a regular expression (RegEx).  The breadth of the search is determined by the supplied scope guid.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/anchor-management/overview/"))
    public AnchorSearchMatchesListResponse findElementsInAnchorScope(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String anchorScopeGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findElementsInAnchorScope(serverName, urlMarker, anchorScopeGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/any-type"})
    @Operation(summary="getAllRelatedMetadataElements", description="Retrieve the metadata elements connected to the supplied element.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public RelatedMetadataElementListResponse getAllRelatedMetadataElements(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startingAtEnd, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.getRelatedMetadataElements(serverName, elementGUID, null, urlMarker, startingAtEnd, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/type/{relationshipTypeName}"})
    @Operation(summary="getRelatedMetadataElements", description="Retrieve the metadata elements connected to the supplied element via a specific relationship type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public RelatedMetadataElementListResponse getRelatedMetadataElements(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String relationshipTypeName, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startingAtEnd, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.getRelatedMetadataElements(serverName, elementGUID, relationshipTypeName, urlMarker, startingAtEnd, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementAtEnd1GUID}/linked-by-any-type/to-elements/{metadataElementAtEnd2GUID}"})
    @Operation(summary="getAllMetadataElementRelationships", description="Retrieve the relationships linking the supplied elements.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataRelationshipListResponse getAllMetadataElementRelationships(@PathVariable String serverName, @PathVariable String metadataElementAtEnd1GUID, @PathVariable String metadataElementAtEnd2GUID, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.getMetadataElementRelationships(serverName, metadataElementAtEnd1GUID, null, metadataElementAtEnd2GUID, urlMarker, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{elementGUID}/with-anchored-elements"})
    @Operation(summary="getAnchoredElementsGraph", description="Return all the elements that are anchored to an element plus relationships between these elements and to other elements.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataGraphResponse getAnchoredElementsGraph(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) AnyTimeRequestBody requestBody) {
        return this.restAPI.getAnchoredElementsGraph(serverName, urlMarker, elementGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementAtEnd1GUID}/linked-by-type/{relationshipTypeName}/to-elements/{metadataElementAtEnd2GUID}"})
    @Operation(summary="getMetadataElementRelationships", description="Retrieve the relationships linking the supplied elements via a specific type of relationship.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataRelationshipListResponse getMetadataElementRelationships(@PathVariable String serverName, @PathVariable String metadataElementAtEnd1GUID, @PathVariable String relationshipTypeName, @PathVariable String metadataElementAtEnd2GUID, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.getMetadataElementRelationships(serverName, metadataElementAtEnd1GUID, relationshipTypeName, metadataElementAtEnd2GUID, urlMarker, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/metadata-elements/by-search-conditions"})
    @Operation(summary="findMetadataElements", description="Return a list of metadata elements that match the supplied criteria.  The results can be returned over many pages.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataElementsResponse findMetadataElements(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FindRequestBody requestBody) {
        return this.restAPI.findMetadataElements(serverName, urlMarker, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/relationships/by-search-conditions"})
    @Operation(summary="findRelationshipsBetweenMetadataElements", description="Return a list of relationships that match the requested conditions.  The results can be received as a series of pages.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataRelationshipListResponse findRelationshipsBetweenMetadataElements(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody FindRelationshipRequestBody requestBody) {
        return this.restAPI.findRelationshipsBetweenMetadataElements(serverName, urlMarker, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/relationships/by-guid/{relationshipGUID}"})
    @Operation(summary="getRelationshipByGUID", description="Retrieve the relationship using its unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataRelationshipResponse getRelationshipByGUID(@PathVariable String serverName, @PathVariable String relationshipGUID, @PathVariable String urlMarker, @RequestBody(required=false) AnyTimeRequestBody requestBody) {
        return this.restAPI.getRelationshipByGUID(serverName, relationshipGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/relationships/{relationshipGUID}/history"})
    @Operation(summary="getRelationshipHistory", description="Retrieve all the versions of a relationship.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/metadata-explorer/overview/"))
    public OpenMetadataRelationshipListResponse getRelationshipHistory(@PathVariable String serverName, @PathVariable String relationshipGUID, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean oldestFirst, @RequestBody(required=false) HistoryRequestBody requestBody) {
        return this.restAPI.getRelationshipHistory(serverName, relationshipGUID, urlMarker, startFrom, pageSize, oldestFirst, requestBody);
    }
}

