/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadataobservability.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum OpenMetadataObservabilityAuditCode implements AuditLogMessageSet
{
    ASSET_ACTIVITY_CREATE("METADATA-OBSERVABILITY-0001", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} created {1} asset {2} during operation {3} of service {4}", "This message is used to capture user requests to create an asset.", "No action is required, but this message can be used to capture user activity information related to asset creation."),
    ASSET_ACTIVITY_READ("METADATA-OBSERVABILITY-0002", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} retrieved {1} asset {2} during operation {3} of service {4}", "This message is used to capture user requests to receive an asset.", "No action is required, but this message can be used to capture user activity information."),
    ASSET_ACTIVITY_READ_ATTACHMENT("METADATA-OBSERVABILITY-0003", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} retrieved an attachment to {1} asset {2} during operation {3} of service {4}", "This message is used to capture user requests to receive full details about an asset.", "No action is required, but this message can be used to capture user activity information about the use of assets."),
    ASSET_ACTIVITY_UPDATE_ATTACHMENT("METADATA-OBSERVABILITY-0004", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} updated an attachment to {1} asset {2} during operation {3} of service {4}", "This message is used to capture user requests to build out the knowledge for an asset.", "No action is required, but this message can be used to capture user activity information related to curation of an asset."),
    ASSET_ACTIVITY_UPDATE_FEEDBACK("METADATA-OBSERVABILITY-0005", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} updated feedback related to {1} asset {2} during operation {3} of service {4}", "This message is used to capture user requests to maintain feedback on an asset.", "No action is required, but this message can be used to capture user activity information related to the maintenance of feedback attached to an asset."),
    ASSET_ACTIVITY_UPDATE("METADATA-OBSERVABILITY-0006", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} updated {1} asset {2} during operation {3} of service {4}", "This message is used to capture user requests to update an asset.", "No action is required, but this message can be used to capture user activity information related to asset updates."),
    ASSET_ACTIVITY_DELETE("METADATA-OBSERVABILITY-0007", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} deleted {1} asset {2} during operation {3} of service {4}", "This message is used to capture user requests to delete an asset.", "No action is required, but this message can be used to capture user activity information related to asset deletion."),
    ASSET_ACTIVITY_SEARCH("METADATA-OBSERVABILITY-0008", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} retrieved {1} asset {2} during search operation {3} of service {4}", "This message is used to capture user requests to retrieve an asset as part of a search request.  The asset may not be the caller's choice.", "No action is required, but this message can be used to capture user activity information relating to the assets being retrieved through searches."),
    ASSET_ACTIVITY_SEARCH_ATTACHMENT("METADATA-OBSERVABILITY-0009", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} retrieved an attachment to {1} asset {2} during search operation {3} of service {4}", "This message is used to capture user requests to retrieve part of an asset as part of a search request.  This asset may not be the caller's choice.", "No action is required, but this message can be used to capture user activity information relating to the attachments of an asset assets being retrieved through searches."),
    USER_REQUEST_ACTIVITY("METADATA-OBSERVABILITY-0010", AuditLogRecordSeverityLevel.ACTIVITY, "User {0} issued REST API call to operation {1} of service {2} on server {3}", "This message is used to capture user activity.", "No action is required, but this message can be used to capture user activity information.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private OpenMetadataObservabilityAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "OpenMetadataObservabilityAuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

