/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.metadatasecurity.properties.Referenceable;

public class Connection
extends Referenceable {
    private static final long serialVersionUID = 1L;
    private String displayName = null;
    private String description = null;
    private String networkAddress = null;
    private String userId = null;
    private String encryptedPassword = null;
    private String clearPassword = null;
    private Map<String, Object> configurationProperties = null;
    private Map<String, Object> securedProperties = null;

    public Connection() {
    }

    public Connection(Connection template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.networkAddress = template.getNetworkAddress();
            this.userId = template.getUserId();
            this.clearPassword = template.getClearPassword();
            this.encryptedPassword = template.getEncryptedPassword();
            this.configurationProperties = template.getConfigurationProperties();
            this.securedProperties = template.getSecuredProperties();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    public String getClearPassword() {
        return this.clearPassword;
    }

    public void setClearPassword(String clearPassword) {
        this.clearPassword = clearPassword;
    }

    public void setConfigurationProperties(Map<String, Object> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public Map<String, Object> getConfigurationProperties() {
        if (this.configurationProperties == null) {
            return null;
        }
        if (this.configurationProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.configurationProperties);
    }

    public void setSecuredProperties(Map<String, Object> securedProperties) {
        this.securedProperties = securedProperties;
    }

    public Map<String, Object> getSecuredProperties() {
        if (this.securedProperties == null) {
            return null;
        }
        if (this.securedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.securedProperties);
    }

    @Override
    public String toString() {
        return "Connection{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", networkAddress='" + this.networkAddress + '\'' + ", userId='" + this.userId + '\'' + ", encryptedPassword='" + this.encryptedPassword + '\'' + ", clearPassword='" + this.clearPassword + '\'' + ", configurationProperties=" + this.configurationProperties + ", securedProperties=" + this.securedProperties + ", typeGUID='" + this.getTypeGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", GUID='" + this.getGUID() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", extendedProperties=" + this.getExtendedProperties() + ", securityLabels=" + this.getSecurityLabels() + ", securityProperties=" + this.getSecurityProperties() + ", confidentiality=" + this.getConfidentiality() + ", confidence=" + this.getConfidence() + ", criticality=" + this.getCriticality() + ", retention=" + this.getRetention() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Connection that = (Connection)objectToCompare;
        return Objects.equals(this.networkAddress, that.networkAddress) && Objects.equals(this.userId, that.userId) && Objects.equals(this.encryptedPassword, that.encryptedPassword) && Objects.equals(this.clearPassword, that.clearPassword) && Objects.equals(this.configurationProperties, that.configurationProperties) && Objects.equals(this.securedProperties, that.securedProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.networkAddress, this.userId, this.encryptedPassword, this.clearPassword, this.configurationProperties, this.securedProperties);
    }
}

