/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.metadatasecurity.properties.Referenceable;

public class Asset
extends Referenceable {
    private static final long serialVersionUID = 1L;
    private String displayName = null;
    private String description = null;
    private String owner = null;
    private int ownerType = 0;
    private List<String> zoneMembership = null;
    private Map<String, String> origin = null;

    public Asset() {
    }

    public Asset(Asset template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.owner = template.getOwner();
            this.ownerType = template.getOwnerType();
            this.zoneMembership = template.getZoneMembership();
            this.origin = template.getOrigin();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(int ownerType) {
        this.ownerType = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public Map<String, String> getOrigin() {
        if (this.origin == null) {
            return null;
        }
        if (this.origin.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.origin);
    }

    public void setOrigin(Map<String, String> origin) {
        this.origin = origin;
    }

    @Override
    public String toString() {
        return "Asset{typeGUID='" + this.getTypeGUID() + "', typeName='" + this.getTypeName() + "', qualifiedName='" + this.getQualifiedName() + "', displayName='" + this.displayName + "', description='" + this.description + "', owner='" + this.owner + "', ownerType=" + this.ownerType + ", zoneMembership=" + this.zoneMembership + ", origin=" + this.origin + ", additionalProperties=" + this.getAdditionalProperties() + ", extendedProperties=" + this.getExtendedProperties() + ", securityLabels=" + this.getSecurityLabels() + ", securityProperties=" + this.getSecurityProperties() + ", confidentiality=" + this.getConfidentiality() + ", confidence=" + this.getConfidence() + ", impact=" + this.getImpact() + ", criticality=" + this.getCriticality() + ", retention=" + this.getRetention() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Asset asset = (Asset)objectToCompare;
        return Objects.equals(this.getDisplayName(), asset.getDisplayName()) && Objects.equals(this.getDescription(), asset.getDescription()) && Objects.equals(this.getOwner(), asset.getOwner()) && this.getOwnerType() == asset.getOwnerType() && Objects.equals(this.getZoneMembership(), asset.getZoneMembership()) && Objects.equals(this.getOrigin(), asset.getOrigin());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDisplayName(), this.getDescription(), this.getOwner(), this.getOwnerType(), this.getZoneMembership(), this.getOrigin());
    }
}

