/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.properties;

import java.io.Serializable;

public enum ReferenceableStatus implements Serializable
{
    UNKNOWN(0, 0, "<Unknown>", "Unknown instance status."),
    DRAFT(1, 1, "Draft", "The content is incomplete."),
    PREPARED(2, 2, "Prepared", "The content is ready for review."),
    PROPOSED(3, 3, "Proposed", "The content is in review."),
    APPROVED(4, 4, "Approved", "The content is approved."),
    REJECTED(5, 5, "Rejected", "The request or proposal is rejected."),
    APPROVED_CONCEPT(6, 6, "Approved concept", "The request or proposal is approved for development."),
    UNDER_DEVELOPMENT(7, 7, "Under development", "The instance is being developed."),
    DEVELOPMENT_COMPLETE(8, 8, "Development complete", "The development of the instance is complete."),
    APPROVED_FOR_DEPLOYMENT(9, 9, "Approved for deployment", "The instance is approved for deployment."),
    STANDBY(10, 10, "StandBy", "The instance is deployed in standby mode."),
    ACTIVE(15, 15, "Active", "The instance is approved and in use."),
    FAILED(20, 20, "Failed", "The instance is not in use due to failure."),
    DISABLED(21, 21, "Disabled", "The instance is shutdown or disabled."),
    COMPLETE(22, 22, "Complete", "The activity associated with the instance is complete."),
    DEPRECATED(30, 30, "Deprecated", "The instance is out of date and should not be used."),
    OTHER(50, 50, "Other", "The instance is in a locally defined state."),
    DELETED(99, 99, "Deleted", "The instance has been deleted and is no longer available.");

    private static final long serialVersionUID = 1L;
    private final int ordinal;
    private final int omrsOrdinal;
    private final String name;
    private final String description;

    private ReferenceableStatus(int ordinal, int omrsOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.omrsOrdinal = omrsOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getOMRSOrdinal() {
        return this.omrsOrdinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ReferenceableStatus{ordinal=" + this.ordinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

