/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.metadatasecurity.properties.Referenceable;

public class Asset
extends Referenceable {
    private String displayName = null;
    private String description = null;
    private List<String> zoneMembership = null;
    private Map<String, String> origin = null;

    public Asset() {
    }

    public Asset(Asset template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.zoneMembership = template.getZoneMembership();
            this.origin = template.getOrigin();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public Map<String, String> getOrigin() {
        if (this.origin == null) {
            return null;
        }
        if (this.origin.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.origin);
    }

    public void setOrigin(Map<String, String> origin) {
        this.origin = origin;
    }

    @Override
    public String toString() {
        return "Asset{displayName='" + this.displayName + "', description='" + this.description + "', zoneMembership=" + this.zoneMembership + ", origin=" + this.origin + ", typeGUID='" + this.getTypeGUID() + "', typeName='" + this.getTypeName() + "', status=" + this.getStatus() + ", GUID='" + this.getGUID() + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", owner='" + this.getOwner() + "', ownerType=" + this.getOwnerType() + ", ownerTypeName='" + this.getOwnerTypeName() + "', ownerPropertyName='" + this.getOwnerPropertyName() + "', extendedProperties=" + this.getExtendedProperties() + ", securityLabels=" + this.getSecurityLabels() + ", securityProperties=" + this.getSecurityProperties() + ", accessGroups=" + this.getAccessGroups() + ", confidentiality=" + this.getConfidentiality() + ", confidence=" + this.getConfidence() + ", criticality=" + this.getCriticality() + ", impact=" + this.getImpact() + ", retention=" + this.getRetention() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Asset asset = (Asset)objectToCompare;
        return Objects.equals(this.getDisplayName(), asset.getDisplayName()) && Objects.equals(this.getDescription(), asset.getDescription()) && Objects.equals(this.getZoneMembership(), asset.getZoneMembership()) && Objects.equals(this.getOrigin(), asset.getOrigin());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDisplayName(), this.getDescription(), this.getZoneMembership(), this.getOrigin());
    }
}

