/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.connectors;

import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataAssetSecurity;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataConnectionSecurity;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataServerSecurity;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataServiceSecurity;
import org.odpi.openmetadata.metadatasecurity.ffdc.OpenMetadataSecurityAuditCode;
import org.odpi.openmetadata.metadatasecurity.ffdc.OpenMetadataSecurityErrorCode;
import org.odpi.openmetadata.metadatasecurity.properties.AssetAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OpenMetadataRepositorySecurity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;

public class OpenMetadataServerSecurityConnector
extends ConnectorBase
implements AuditLoggingComponent,
OpenMetadataRepositorySecurity,
OpenMetadataServerSecurity,
OpenMetadataServiceSecurity,
OpenMetadataConnectionSecurity,
OpenMetadataAssetSecurity {
    protected AuditLog auditLog = null;
    protected String serverName = null;
    protected String localServerUserId = null;
    protected String connectorName = null;
    protected final String unknownTypeName = "<Unknown>";

    protected void logConnectorStarting() {
        if (this.auditLog != null) {
            String actionDescription = "start";
            this.auditLog.logMessage("start", OpenMetadataSecurityAuditCode.SERVICE_INITIALIZING.getMessageDefinition(this.connectorName, this.serverName));
        }
    }

    protected void logConnectorDisconnecting() {
        if (this.auditLog != null) {
            String actionDescription = "disconnect";
            this.auditLog.logMessage("disconnect", OpenMetadataSecurityAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.connectorName, this.serverName));
        }
    }

    protected String getAssetGUID(Asset asset) {
        if (asset == null) {
            return "<null>";
        }
        if (asset.getGUID() == null) {
            return "<null-guid>";
        }
        return asset.getGUID();
    }

    protected String printZoneList(List<String> zones) {
        if (zones == null) {
            return "<null>";
        }
        if (zones.isEmpty()) {
            return "[]";
        }
        return zones.toString();
    }

    protected String getConnectionQualifiedName(Connection connection) {
        if (connection == null) {
            return "<null>";
        }
        if (connection.getQualifiedName() == null) {
            return "<null-name>";
        }
        return connection.getQualifiedName();
    }

    protected String getInstanceGUID(InstanceHeader instance) {
        if (instance == null) {
            return "<null>";
        }
        if (instance.getGUID() == null) {
            return "<null-guid>";
        }
        return instance.getGUID();
    }

    protected void throwUnauthorizedServerAccess(String userId, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_SERVER_ACCESS.getMessageDefinition(userId, this.serverName));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_SERVER_ACCESS.getMessageDefinition(userId, this.serverName), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedServiceAccess(String userId, String serviceName, String serviceOperationName, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_SERVICE_ACCESS.getMessageDefinition(userId, serviceOperationName, serviceName, this.serverName));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_SERVICE_ACCESS.getMessageDefinition(userId, serviceOperationName), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedTypeAccess(String userId, String typeGUID, String typeName, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_TYPE_ACCESS.getMessageDefinition(userId, typeName, typeGUID, this.serverName));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_TYPE_ACCESS.getMessageDefinition(userId, typeName, typeGUID, this.serverName), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedTypeChange(String userId, String typeGUID, String typeName, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_TYPE_CHANGE.getMessageDefinition(userId, typeName, typeGUID, this.serverName));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_TYPE_CHANGE.getMessageDefinition(userId, typeName, typeGUID, this.serverName), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedInstanceCreate(String userId, String typeGUID, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_INSTANCE_CREATE.getMessageDefinition(userId, typeGUID, this.serverName));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_TYPE_CHANGE.getMessageDefinition(userId, typeGUID, this.serverName), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedInstanceAccess(String userId, String instanceGUID, String typeName, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_INSTANCE_ACCESS.getMessageDefinition(userId, instanceGUID, typeName, this.serverName));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_INSTANCE_ACCESS.getMessageDefinition(userId, instanceGUID, typeName, this.serverName), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedInstanceChange(String userId, String instanceGUID, String typeName, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_INSTANCE_CHANGE.getMessageDefinition(userId, instanceGUID, typeName, this.serverName, methodName));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_INSTANCE_CHANGE.getMessageDefinition(userId, instanceGUID, typeName, this.serverName), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedAssetAccess(String userId, Asset asset, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_ASSET_ACCESS.getMessageDefinition(userId, this.getAssetGUID(asset)));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_ASSET_ACCESS.getMessageDefinition(userId, this.getAssetGUID(asset)), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedAssetChange(String userId, Asset asset, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_ASSET_CHANGE.getMessageDefinition(userId, this.getAssetGUID(asset)));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_ASSET_CHANGE.getMessageDefinition(userId, this.getAssetGUID(asset)), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwIncompleteAsset(String userId, Asset asset, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.INCOMPLETE_ASSET.getMessageDefinition(userId, this.getAssetGUID(asset)));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.INCOMPLETE_ASSET.getMessageDefinition(userId, this.getAssetGUID(asset)), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedZoneChange(String userId, Asset asset, List<String> originalZones, List<String> newZones, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_ZONE_CHANGE.getMessageDefinition(userId, this.getAssetGUID(asset), this.printZoneList(originalZones), this.printZoneList(newZones)));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_ZONE_CHANGE.getMessageDefinition(userId, this.getAssetGUID(asset), this.printZoneList(originalZones), this.printZoneList(newZones)), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedAssetFeedback(String userId, Asset asset, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_ASSET_FEEDBACK.getMessageDefinition(userId, this.getAssetGUID(asset)));
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_ASSET_FEEDBACK.getMessageDefinition(userId, this.getAssetGUID(asset)), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedConnectionAccess(String userId, Connection connection, String methodName) throws UserNotAuthorizedException {
        if (this.auditLog != null) {
            this.auditLog.logMessage(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_SERVICE_ACCESS.getMessageDefinition(userId, this.getConnectionQualifiedName(connection)), connection.toString());
        }
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_SERVICE_ACCESS.getMessageDefinition(userId, this.getConnectionQualifiedName(connection)), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setLocalServerUserId(String userId) {
        this.localServerUserId = userId;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        this.connectorName = ((Object)((Object)this)).getClass().getName();
        this.logConnectorStarting();
    }

    public List<String> setSupportedZonesForUser(List<String> supportedZones, String serviceName, String user) throws InvalidParameterException, PropertyServerException {
        return supportedZones;
    }

    public List<String> initializeAssetZones(List<String> defaultZones, Asset asset) throws InvalidParameterException, PropertyServerException {
        List resultingZones = null;
        if (asset != null) {
            resultingZones = asset.getZoneMembership() == null || asset.getZoneMembership().isEmpty() ? defaultZones : asset.getZoneMembership();
        }
        return resultingZones;
    }

    public List<String> verifyAssetZones(List<String> defaultZones, List<String> supportedZones, Asset originalAsset, Asset updatedAsset) throws InvalidParameterException, PropertyServerException {
        List resultingZones = null;
        if (updatedAsset != null) {
            resultingZones = updatedAsset.getZoneMembership();
        }
        return resultingZones;
    }

    public void validateUserForServer(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserForServer";
        this.throwUnauthorizedServerAccess(userId, "validateUserForServer");
    }

    public void validateUserAsServerAdmin(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsServerAdmin";
        String serviceName = "Administration Services";
        String serviceOperationName = "configuration";
        this.throwUnauthorizedServiceAccess(userId, "Administration Services", "configuration", "validateUserAsServerAdmin");
    }

    public void validateUserAsServerOperator(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsServerOperator";
        String serviceName = "Administration Services";
        String serviceOperationName = "operations";
        this.throwUnauthorizedServiceAccess(userId, "Administration Services", "operations", "validateUserAsServerOperator");
    }

    public void validateUserAsServerInvestigator(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsServerInvestigator";
        String serviceName = "Administration Services";
        String serviceOperationName = "query";
        this.throwUnauthorizedServiceAccess(userId, "Administration Services", "query", "validateUserAsServerInvestigator");
    }

    public void validateUserForService(String userId, String serviceName) throws UserNotAuthorizedException {
        String methodName = "validateUserForService";
        String serviceOperationName = "any";
        this.throwUnauthorizedServiceAccess(userId, serviceName, "any", "validateUserForService");
    }

    public void validateUserForServiceOperation(String userId, String serviceName, String serviceOperationName) throws UserNotAuthorizedException {
        String methodName = "validateUserForServiceOperation";
        this.throwUnauthorizedServiceAccess(userId, serviceName, serviceOperationName, "validateUserForServiceOperation");
    }

    public void validateUserForConnection(String userId, Connection connection) throws UserNotAuthorizedException {
        String methodName = "validateUserForConnection";
        this.throwUnauthorizedConnectionAccess(userId, connection, "validateUserForConnection");
    }

    public void validateUserForAssetCreate(String userId, Asset asset) throws UserNotAuthorizedException {
        String methodName = "validateUserForAssetCreate";
        this.throwUnauthorizedAssetChange(userId, asset, "validateUserForAssetCreate");
    }

    public void validateUserForAssetRead(String userId, Asset asset) throws UserNotAuthorizedException {
        String methodName = "validateUserForAssetRead";
        this.throwUnauthorizedAssetAccess(userId, asset, "validateUserForAssetRead");
    }

    public void validateUserForAssetDetailUpdate(String userId, Asset originalAsset, AssetAuditHeader originalAssetAuditHeader, Asset newAsset) throws UserNotAuthorizedException {
        String methodName = "validateUserForAssetDetailUpdate";
        this.throwUnauthorizedAssetChange(userId, originalAsset, "validateUserForAssetDetailUpdate");
    }

    public void validateUserForAssetAttachmentUpdate(String userId, Asset asset) throws UserNotAuthorizedException {
        String methodName = "validateUserForAssetAttachmentUpdate";
        this.throwUnauthorizedAssetChange(userId, asset, "validateUserForAssetAttachmentUpdate");
    }

    public void validateUserForAssetFeedback(String userId, Asset asset) throws UserNotAuthorizedException {
        String methodName = "validateUserForAssetFeedback";
        this.throwUnauthorizedAssetFeedback(userId, asset, "validateUserForAssetFeedback");
    }

    public void validateUserForAssetDelete(String userId, Asset asset) throws UserNotAuthorizedException {
        String methodName = "validateUserForAssetDelete";
        this.throwUnauthorizedAssetChange(userId, asset, "validateUserForAssetDelete");
    }

    public void validateUserForTypeCreate(String userId, String metadataCollectionName, TypeDef typeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeCreate";
        if (typeDef != null) {
            this.throwUnauthorizedTypeChange(userId, typeDef.getGUID(), typeDef.getName(), "validateUserForTypeCreate");
        }
    }

    public void validateUserForTypeCreate(String userId, String metadataCollectionName, AttributeTypeDef attributeTypeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeCreate";
        if (attributeTypeDef != null) {
            this.throwUnauthorizedTypeChange(userId, attributeTypeDef.getGUID(), attributeTypeDef.getName(), "validateUserForTypeCreate");
        }
    }

    public void validateUserForTypeRead(String userId, String metadataCollectionName, TypeDef typeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeRead";
        if (typeDef != null) {
            this.throwUnauthorizedTypeAccess(userId, typeDef.getGUID(), typeDef.getName(), "validateUserForTypeRead");
        }
    }

    public void validateUserForTypeRead(String userId, String metadataCollectionName, AttributeTypeDef attributeTypeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeRead";
        if (attributeTypeDef != null) {
            this.throwUnauthorizedTypeAccess(userId, attributeTypeDef.getGUID(), attributeTypeDef.getName(), "validateUserForTypeRead");
        }
    }

    public void validateUserForTypeUpdate(String userId, String metadataCollectionName, TypeDef typeDef, TypeDefPatch patch) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeUpdate";
        if (typeDef != null) {
            this.throwUnauthorizedTypeChange(userId, typeDef.getGUID(), typeDef.getName(), "validateUserForTypeUpdate");
        }
    }

    public void validateUserForTypeDelete(String userId, String metadataCollectionName, TypeDef typeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeDelete";
        if (typeDef != null) {
            this.throwUnauthorizedTypeChange(userId, typeDef.getGUID(), typeDef.getName(), "validateUserForTypeDelete");
        }
    }

    public void validateUserForTypeDelete(String userId, String metadataCollectionName, AttributeTypeDef attributeTypeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeDelete";
        if (attributeTypeDef != null) {
            this.throwUnauthorizedTypeChange(userId, attributeTypeDef.getGUID(), attributeTypeDef.getName(), "validateUserForTypeDelete");
        }
    }

    public void validateUserForTypeReIdentify(String userId, String metadataCollectionName, TypeDef originalTypeDef, String newTypeDefGUID, String newTypeDefName) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeReIdentify";
        if (originalTypeDef != null) {
            this.throwUnauthorizedTypeChange(userId, originalTypeDef.getGUID(), originalTypeDef.getName(), "validateUserForTypeReIdentify");
        }
    }

    public void validateUserForTypeReIdentify(String userId, String metadataCollectionName, AttributeTypeDef originalAttributeTypeDef, String newTypeDefGUID, String newTypeDefName) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeReIdentify";
        if (originalAttributeTypeDef != null) {
            this.throwUnauthorizedTypeChange(userId, originalAttributeTypeDef.getGUID(), originalAttributeTypeDef.getName(), "validateUserForTypeReIdentify");
        }
    }

    public void validateUserForEntityCreate(String userId, String metadataCollectionName, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityCreate";
        this.throwUnauthorizedInstanceCreate(userId, entityTypeGUID, "validateUserForEntityCreate");
    }

    public void validateUserForEntityRead(String userId, String metadataCollectionName, EntityDetail instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityRead";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceAccess(userId, instance.getGUID(), typeName, "validateUserForEntityRead");
        }
    }

    public void validateUserForEntitySummaryRead(String userId, String metadataCollectionName, EntitySummary instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntitySummaryRead";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceAccess(userId, instance.getGUID(), typeName, "validateUserForEntitySummaryRead");
        }
    }

    public void validateUserForEntityProxyRead(String userId, String metadataCollectionName, EntityProxy instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityProxyRead";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceAccess(userId, instance.getGUID(), typeName, "validateUserForEntityProxyRead");
        }
    }

    public void validateUserForEntityUpdate(String userId, String metadataCollectionName, EntityDetail instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityUpdate";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityUpdate");
        }
    }

    public void validateUserForEntityClassificationAdd(String userId, String metadataCollectionName, EntityDetail instance, String classificationName, InstanceProperties properties) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityClassificationAdd";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityClassificationAdd");
        }
    }

    public void validateUserForEntityClassificationUpdate(String userId, String metadataCollectionName, EntityDetail instance, String classificationName, InstanceProperties properties) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityClassificationUpdate";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityClassificationUpdate");
        }
    }

    public void validateUserForEntityClassificationDelete(String userId, String metadataCollectionName, EntityDetail instance, String classificationName) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityClassificationDelete";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityClassificationDelete");
        }
    }

    public void validateUserForEntityDelete(String userId, String metadataCollectionName, EntityDetail instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityDelete";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityDelete");
        }
    }

    public void validateUserForEntityRestore(String userId, String metadataCollectionName, String deletedEntityGUID) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityRestore";
        this.throwUnauthorizedInstanceChange(userId, deletedEntityGUID, "<Unknown>", "validateUserForEntityRestore");
    }

    public void validateUserForEntityReIdentification(String userId, String metadataCollectionName, EntityDetail instance, String newGUID) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityReIdentification";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForEntityReIdentification");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForEntityReIdentification");
            }
        }
    }

    public void validateUserForEntityReTyping(String userId, String metadataCollectionName, EntityDetail instance, TypeDefSummary newTypeDefSummary) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityReTyping";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForEntityReTyping");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForEntityReTyping");
            }
        }
    }

    public void validateUserForEntityReHoming(String userId, String metadataCollectionName, EntityDetail instance, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityReHoming";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForEntityReHoming");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForEntityReHoming");
            }
        }
    }

    public void validateUserForRelationshipCreate(String userId, String metadataCollectionName, String relationshipTypeGUID, InstanceProperties initialProperties, EntitySummary entityOneSummary, EntitySummary entityTwoSummary, InstanceStatus initialStatus) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipCreate";
        this.throwUnauthorizedInstanceCreate(userId, relationshipTypeGUID, "validateUserForRelationshipCreate");
    }

    public void validateUserForRelationshipRead(String userId, String metadataCollectionName, Relationship instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipRead";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceAccess(userId, instance.getGUID(), typeName, "validateUserForRelationshipRead");
        }
    }

    public void validateUserForRelationshipUpdate(String userId, String metadataCollectionName, Relationship instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipUpdate";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForRelationshipUpdate");
        }
    }

    public void validateUserForRelationshipDelete(String userId, String metadataCollectionName, Relationship instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipDelete";
        if (instance != null) {
            String typeName = "<Unknown>";
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForRelationshipDelete");
        }
    }

    public void validateUserForRelationshipRestore(String userId, String metadataCollectionName, String deletedRelationshipGUID) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipRestore";
        this.throwUnauthorizedInstanceChange(userId, deletedRelationshipGUID, "<Unknown>", "validateUserForRelationshipRestore");
    }

    public void validateUserForRelationshipReIdentification(String userId, String metadataCollectionName, Relationship instance, String newGUID) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipReIdentification";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForRelationshipReIdentification");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForRelationshipReIdentification");
            }
        }
    }

    public void validateUserForRelationshipReTyping(String userId, String metadataCollectionName, Relationship instance, TypeDefSummary newTypeDefSummary) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipReTyping";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForRelationshipReTyping");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForRelationshipReTyping");
            }
        }
    }

    public void validateUserForRelationshipReHoming(String userId, String metadataCollectionName, Relationship instance, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipReHoming";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForRelationshipReHoming");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForRelationshipReHoming");
            }
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        this.logConnectorDisconnecting();
    }
}

