/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.connectors;

import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataPlatformSecurity;
import org.odpi.openmetadata.metadatasecurity.ffdc.OpenMetadataSecurityAuditCode;
import org.odpi.openmetadata.metadatasecurity.ffdc.OpenMetadataSecurityErrorCode;

public class OpenMetadataPlatformSecurityConnector
extends ConnectorBase
implements OpenMetadataPlatformSecurity {
    protected MessageFormatter messageFormatter = new MessageFormatter();
    protected String connectorName = null;
    protected String serverRootURL = null;

    protected void logRecord(String logMessageId, AuditLogRecordSeverity severity, String logMessage) {
        System.out.println(severity.getName() + " " + logMessageId + " " + logMessage);
    }

    protected void logConnectorStarting() {
        AuditLogMessageDefinition messageDefinition = OpenMetadataSecurityAuditCode.PLATFORM_INITIALIZING.getMessageDefinition(this.connectorName, this.serverRootURL);
        this.logRecord(messageDefinition.getMessageId(), messageDefinition.getSeverity(), this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
    }

    protected void logConnectorDisconnecting() {
        AuditLogMessageDefinition messageDefinition = OpenMetadataSecurityAuditCode.PLATFORM_SHUTDOWN.getMessageDefinition(this.connectorName, this.serverRootURL);
        this.logRecord(messageDefinition.getMessageId(), messageDefinition.getSeverity(), this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
    }

    public void setServerPlatformURL(String serverURLRoot) {
        this.serverRootURL = serverURLRoot;
    }

    protected void throwUnauthorizedPlatformAccess(String userId, String methodName) throws UserNotAuthorizedException {
        AuditLogMessageDefinition messageDefinition = OpenMetadataSecurityAuditCode.UNAUTHORIZED_PLATFORM_ACCESS.getMessageDefinition(userId, this.serverRootURL);
        this.logRecord(messageDefinition.getMessageId(), messageDefinition.getSeverity(), this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_PLATFORM_ACCESS.getMessageDefinition(userId, this.serverRootURL), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        this.connectorName = ((Object)((Object)this)).getClass().getName();
        this.logConnectorStarting();
    }

    public void validateUserForNewServer(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserForNewServer";
        this.throwUnauthorizedPlatformAccess(userId, "validateUserForNewServer");
    }

    public void validateUserAsOperatorForPlatform(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsOperatorForPlatform";
        this.throwUnauthorizedPlatformAccess(userId, "validateUserAsOperatorForPlatform");
    }

    public void validateUserAsInvestigatorForPlatform(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsInvestigatorForPlatform";
        this.throwUnauthorizedPlatformAccess(userId, "validateUserAsInvestigatorForPlatform");
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        this.logConnectorDisconnecting();
    }
}

