/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.connectors;

import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataPlatformSecurity;
import org.odpi.openmetadata.metadatasecurity.connectors.OpenMetadataSecurityConnector;
import org.odpi.openmetadata.metadatasecurity.ffdc.OpenMetadataSecurityAuditCode;

public class OpenMetadataPlatformSecurityConnector
extends OpenMetadataSecurityConnector
implements OpenMetadataPlatformSecurity {
    protected MessageFormatter messageFormatter = new MessageFormatter();

    protected void logRecord(AuditLogRecordSeverity severity, String logMessage) {
        System.out.println(severity.getName() + " " + logMessage);
    }

    @Override
    protected void logConnectorStarting() {
        AuditLogMessageDefinition messageDefinition = OpenMetadataSecurityAuditCode.PLATFORM_INITIALIZING.getMessageDefinition(new String[]{this.connectorName, this.serverRootURL});
        this.logRecord(messageDefinition.getSeverity(), this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
    }

    @Override
    protected void logConnectorDisconnecting() {
        AuditLogMessageDefinition messageDefinition = OpenMetadataSecurityAuditCode.PLATFORM_SHUTDOWN.getMessageDefinition(new String[]{this.connectorName, this.serverRootURL});
        this.logRecord(messageDefinition.getSeverity(), this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
    }
}

