/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.connectors;

import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.ffdc.OpenMetadataSecurityAuditCode;
import org.odpi.openmetadata.metadatasecurity.ffdc.OpenMetadataSecurityErrorCode;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;

public class OpenMetadataSecurityConnector
extends ConnectorBase
implements AuditLoggingComponent {
    protected String serverRootURL = null;
    protected String serverName = "platform";
    protected String localServerUserId = null;
    protected String connectorName = null;
    protected final String unknownTypeName = "<Unknown>";

    protected void logConnectorStarting() {
        String actionDescription = "Connector starting";
        if (this.auditLog != null) {
            this.logRecord("Connector starting", OpenMetadataSecurityAuditCode.SERVICE_INITIALIZING.getMessageDefinition(new String[]{this.connectorName, this.serverName}));
        }
    }

    protected void logConnectorDisconnecting() {
        String actionDescription = "disconnecting connector";
        if (this.auditLog != null) {
            this.logRecord("disconnecting connector", OpenMetadataSecurityAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.connectorName, this.serverName}));
        }
    }

    public void setServerPlatformURL(String serverURLRoot) {
        this.serverRootURL = serverURLRoot;
    }

    protected void throwUnauthorizedPlatformAccess(String userId, String methodName) throws UserNotAuthorizedException {
        AuditLogMessageDefinition messageDefinition = OpenMetadataSecurityAuditCode.UNAUTHORIZED_PLATFORM_ACCESS.getMessageDefinition(new String[]{userId, this.serverRootURL});
        this.logRecord(methodName, messageDefinition);
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_PLATFORM_ACCESS.getMessageDefinition(new String[]{userId, this.serverRootURL}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected String printZoneList(List<String> zones) {
        if (zones == null) {
            return "<null>";
        }
        if (zones.isEmpty()) {
            return "[]";
        }
        return zones.toString();
    }

    protected void throwUnauthorizedServerAccess(String userId, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_SERVER_ACCESS.getMessageDefinition(new String[]{userId, this.serverName}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_SERVER_ACCESS.getMessageDefinition(new String[]{userId, this.serverName}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedServiceAccess(String userId, String serviceName, String serviceOperationName, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_SERVICE_ACCESS.getMessageDefinition(new String[]{userId, serviceOperationName, serviceName, this.serverName}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_SERVICE_ACCESS.getMessageDefinition(new String[]{userId, serviceOperationName}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedTypeAccess(String userId, String typeGUID, String typeName, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_TYPE_ACCESS.getMessageDefinition(new String[]{userId, typeName, typeGUID, this.serverName}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_TYPE_ACCESS.getMessageDefinition(new String[]{userId, typeName, typeGUID, this.serverName}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedTypeChange(String userId, String typeGUID, String typeName, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_TYPE_CHANGE.getMessageDefinition(new String[]{userId, typeName, typeGUID, this.serverName}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_TYPE_CHANGE.getMessageDefinition(new String[]{userId, typeName, typeGUID, this.serverName}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedInstanceCreate(String userId, String typeGUID, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_INSTANCE_CREATE.getMessageDefinition(new String[]{userId, typeGUID, this.serverName}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_TYPE_CHANGE.getMessageDefinition(new String[]{userId, typeGUID, this.serverName}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedInstanceAccess(String userId, String instanceGUID, String typeName, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_INSTANCE_ACCESS.getMessageDefinition(new String[]{userId, instanceGUID, typeName, this.serverName}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_INSTANCE_ACCESS.getMessageDefinition(new String[]{userId, instanceGUID, typeName, this.serverName}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedInstanceChange(String userId, String instanceGUID, String typeName, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_INSTANCE_CHANGE.getMessageDefinition(new String[]{userId, instanceGUID, typeName, this.serverName, methodName}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_INSTANCE_CHANGE.getMessageDefinition(new String[]{userId, instanceGUID, typeName, this.serverName}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedAnchorAccess(String userId, String operationName, String elementTypeName, String elementGUID, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_ANCHOR_ACCESS.getMessageDefinition(new String[]{userId, operationName, elementTypeName, elementGUID}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_ANCHOR_ACCESS.getMessageDefinition(new String[]{userId, operationName, elementTypeName, elementGUID}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnknownUser(String userId, Exception underLyingException, String methodName) throws UserNotAuthorizedException {
        if (underLyingException == null) {
            this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNKNOWN_USER.getMessageDefinition(new String[]{userId}));
            throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNKNOWN_USER.getMessageDefinition(new String[]{userId}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
        }
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.FAILED_TO_RETRIEVE_USER.getMessageDefinition(new String[]{underLyingException.getClass().getName(), userId, underLyingException.getMessage()}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.FAILED_TO_RETRIEVE_USER.getMessageDefinition(new String[]{underLyingException.getClass().getName(), userId, underLyingException.getMessage()}), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)underLyingException, userId);
    }

    protected void throwUnauthorizedZoneChange(String userId, String elementGUID, List<String> originalZones, List<String> newZones, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_ZONE_CHANGE.getMessageDefinition(new String[]{userId, elementGUID, this.printZoneList(originalZones), this.printZoneList(newZones)}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_ZONE_CHANGE.getMessageDefinition(new String[]{userId, elementGUID, this.printZoneList(originalZones), this.printZoneList(newZones)}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedAddFeedback(String userId, String elementGUID, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_ADD_FEEDBACK.getMessageDefinition(new String[]{userId, elementGUID}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_ASSET_FEEDBACK.getMessageDefinition(new String[]{userId, elementGUID}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwMissingAnchor(String userId, String operation, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.NULL_ANCHOR.getMessageDefinition(new String[]{userId, operation}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.NULL_ANCHOR.getMessageDefinition(new String[]{userId, operation}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    protected void throwUnauthorizedElementAccess(String userId, String operation, String entityGUID, String entityTypeName, String methodName) throws UserNotAuthorizedException {
        this.logRecord(methodName, OpenMetadataSecurityAuditCode.UNAUTHORIZED_ELEMENT_ACCESS.getMessageDefinition(new String[]{userId, operation, entityTypeName, entityGUID}));
        throw new UserNotAuthorizedException(OpenMetadataSecurityErrorCode.UNAUTHORIZED_ELEMENT_ACCESS.getMessageDefinition(new String[]{userId, operation, entityTypeName, entityGUID}), ((Object)((Object)this)).getClass().getName(), methodName, userId);
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setLocalServerUserId(String userId) {
        this.localServerUserId = userId;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        this.connectorName = ((Object)((Object)this)).getClass().getName();
        this.logConnectorStarting();
    }

    protected List<String> setSupportedZonesForUser(List<String> supportedZones, String serviceName, String user) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return supportedZones;
    }

    public void validateUserForNewServer(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserForNewServer";
        this.throwUnauthorizedPlatformAccess(userId, "validateUserForNewServer");
    }

    public void validateUserAsOperatorForPlatform(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsOperatorForPlatform";
        this.throwUnauthorizedPlatformAccess(userId, "validateUserAsOperatorForPlatform");
    }

    public void validateUserAsInvestigatorForPlatform(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsInvestigatorForPlatform";
        this.throwUnauthorizedPlatformAccess(userId, "validateUserAsInvestigatorForPlatform");
    }

    protected void validateUserForServer(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserForServer";
        this.throwUnauthorizedServerAccess(userId, "validateUserForServer");
    }

    protected void validateUserAsServerAdmin(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsServerAdmin";
        String serviceName = "Administration Services";
        String serviceOperationName = "configuration";
        this.throwUnauthorizedServiceAccess(userId, "Administration Services", "configuration", "validateUserAsServerAdmin");
    }

    protected void validateUserAsServerOperator(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsServerOperator";
        String serviceName = "Administration Services";
        String serviceOperationName = "operations";
        this.throwUnauthorizedServiceAccess(userId, "Administration Services", "operations", "validateUserAsServerOperator");
    }

    protected void validateUserAsServerInvestigator(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsServerInvestigator";
        String serviceName = "Administration Services";
        String serviceOperationName = "query";
        this.throwUnauthorizedServiceAccess(userId, "Administration Services", "query", "validateUserAsServerInvestigator");
    }

    protected void validateUserForService(String userId, String serviceName) throws UserNotAuthorizedException {
        String methodName = "validateUserForService";
        String serviceOperationName = "any";
        this.throwUnauthorizedServiceAccess(userId, serviceName, "any", "validateUserForService");
    }

    protected void validateUserForServiceOperation(String userId, String serviceName, String serviceOperationName) throws UserNotAuthorizedException {
        String methodName = "validateUserForServiceOperation";
        this.throwUnauthorizedServiceAccess(userId, serviceName, serviceOperationName, "validateUserForServiceOperation");
    }

    protected void validateUserForTypeCreate(String userId, String metadataCollectionName, TypeDef typeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeCreate";
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        if (typeDef != null) {
            this.throwUnauthorizedTypeChange(userId, typeDef.getGUID(), typeDef.getName(), "validateUserForTypeCreate");
        }
    }

    protected void validateUserForTypeCreate(String userId, String metadataCollectionName, AttributeTypeDef attributeTypeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeCreate";
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        if (attributeTypeDef != null) {
            this.throwUnauthorizedTypeChange(userId, attributeTypeDef.getGUID(), attributeTypeDef.getName(), "validateUserForTypeCreate");
        }
    }

    protected void validateUserForTypeRead(String userId, String metadataCollectionName, TypeDef typeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeRead";
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        if (typeDef != null) {
            this.throwUnauthorizedTypeAccess(userId, typeDef.getGUID(), typeDef.getName(), "validateUserForTypeRead");
        }
    }

    protected void validateUserForTypeRead(String userId, String metadataCollectionName, AttributeTypeDef attributeTypeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeRead";
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        if (attributeTypeDef != null) {
            this.throwUnauthorizedTypeAccess(userId, attributeTypeDef.getGUID(), attributeTypeDef.getName(), "validateUserForTypeRead");
        }
    }

    protected void validateUserForTypeUpdate(String userId, String metadataCollectionName, TypeDef typeDef, TypeDefPatch patch) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeUpdate";
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        if (typeDef != null) {
            this.throwUnauthorizedTypeChange(userId, typeDef.getGUID(), typeDef.getName(), "validateUserForTypeUpdate");
        }
    }

    protected void validateUserForTypeDelete(String userId, String metadataCollectionName, TypeDef typeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeDelete";
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        if (typeDef != null) {
            this.throwUnauthorizedTypeChange(userId, typeDef.getGUID(), typeDef.getName(), "validateUserForTypeDelete");
        }
    }

    protected void validateUserForTypeDelete(String userId, String metadataCollectionName, AttributeTypeDef attributeTypeDef) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeDelete";
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        if (attributeTypeDef != null) {
            this.throwUnauthorizedTypeChange(userId, attributeTypeDef.getGUID(), attributeTypeDef.getName(), "validateUserForTypeDelete");
        }
    }

    protected void validateUserForTypeReIdentify(String userId, String metadataCollectionName, TypeDef originalTypeDef, String newTypeDefGUID, String newTypeDefName) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeReIdentify";
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        if (originalTypeDef != null) {
            this.throwUnauthorizedTypeChange(userId, originalTypeDef.getGUID(), originalTypeDef.getName(), "validateUserForTypeReIdentify");
        }
    }

    protected void validateUserForTypeReIdentify(String userId, String metadataCollectionName, AttributeTypeDef originalAttributeTypeDef, String newTypeDefGUID, String newTypeDefName) throws UserNotAuthorizedException {
        String methodName = "validateUserForTypeReIdentify";
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        if (originalAttributeTypeDef != null) {
            this.throwUnauthorizedTypeChange(userId, originalAttributeTypeDef.getGUID(), originalAttributeTypeDef.getName(), "validateUserForTypeReIdentify");
        }
    }

    protected void validateUserForEntityCreate(String userId, String metadataCollectionName, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityCreate";
        this.throwUnauthorizedInstanceCreate(userId, entityTypeGUID, "validateUserForEntityCreate");
    }

    protected EntityDetail validateUserForEntityRead(String userId, String metadataCollectionName, EntityDetail instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityRead";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceAccess(userId, instance.getGUID(), typeName, "validateUserForEntityRead");
        }
        return null;
    }

    protected void validateUserForEntitySummaryRead(String userId, String metadataCollectionName, EntitySummary instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntitySummaryRead";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceAccess(userId, instance.getGUID(), typeName, "validateUserForEntitySummaryRead");
        }
    }

    protected void validateUserForEntityProxyRead(String userId, String metadataCollectionName, EntityProxy instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityProxyRead";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceAccess(userId, instance.getGUID(), typeName, "validateUserForEntityProxyRead");
        }
    }

    protected void validateUserForEntityUpdate(String userId, String metadataCollectionName, EntityDetail instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityUpdate";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityUpdate");
        }
    }

    protected void validateUserForEntityClassificationAdd(String userId, String metadataCollectionName, EntitySummary instance, String classificationName, InstanceProperties properties) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityClassificationAdd";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityClassificationAdd");
        }
    }

    protected void validateUserForEntityClassificationUpdate(String userId, String metadataCollectionName, EntitySummary instance, String classificationName, InstanceProperties properties) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityClassificationUpdate";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityClassificationUpdate");
        }
    }

    protected void validateUserForEntityClassificationDelete(String userId, String metadataCollectionName, EntitySummary instance, String classificationName) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityClassificationDelete";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityClassificationDelete");
        }
    }

    protected void validateUserForEntityDelete(String userId, String metadataCollectionName, EntityDetail instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityDelete";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForEntityDelete");
        }
    }

    protected void validateUserForEntityRestore(String userId, String metadataCollectionName, String deletedEntityGUID) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityRestore";
        this.throwUnauthorizedInstanceChange(userId, deletedEntityGUID, "<Unknown>", "validateUserForEntityRestore");
    }

    protected void validateUserForEntityReIdentification(String userId, String metadataCollectionName, EntityDetail instance, String newGUID) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityReIdentification";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForEntityReIdentification");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForEntityReIdentification");
            }
        }
    }

    protected void validateUserForEntityReTyping(String userId, String metadataCollectionName, EntityDetail instance, TypeDefSummary newTypeDefSummary) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityReTyping";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForEntityReTyping");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForEntityReTyping");
            }
        }
    }

    protected void validateUserForEntityReHoming(String userId, String metadataCollectionName, EntityDetail instance, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws UserNotAuthorizedException {
        String methodName = "validateUserForEntityReHoming";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForEntityReHoming");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForEntityReHoming");
            }
        }
    }

    protected void validateUserForRelationshipCreate(String userId, String metadataCollectionName, String relationshipTypeGUID, InstanceProperties initialProperties, EntitySummary entityOneSummary, EntitySummary entityTwoSummary, InstanceStatus initialStatus) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipCreate";
        this.throwUnauthorizedInstanceCreate(userId, relationshipTypeGUID, "validateUserForRelationshipCreate");
    }

    protected Relationship validateUserForRelationshipRead(String userId, String metadataCollectionName, Relationship instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipRead";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceAccess(userId, instance.getGUID(), typeName, "validateUserForRelationshipRead");
        }
        return null;
    }

    protected void validateUserForRelationshipUpdate(String userId, String metadataCollectionName, Relationship instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipUpdate";
        if (instance != null) {
            String typeName = null;
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForRelationshipUpdate");
        }
    }

    protected void validateUserForRelationshipDelete(String userId, String metadataCollectionName, Relationship instance) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipDelete";
        if (instance != null) {
            String typeName = "<Unknown>";
            if (instance.getType() != null) {
                typeName = instance.getType().getTypeDefName();
            }
            this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), typeName, "validateUserForRelationshipDelete");
        }
    }

    protected void validateUserForRelationshipRestore(String userId, String metadataCollectionName, String deletedRelationshipGUID) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipRestore";
        this.throwUnauthorizedInstanceChange(userId, deletedRelationshipGUID, "<Unknown>", "validateUserForRelationshipRestore");
    }

    protected void validateUserForRelationshipReIdentification(String userId, String metadataCollectionName, Relationship instance, String newGUID) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipReIdentification";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForRelationshipReIdentification");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForRelationshipReIdentification");
            }
        }
    }

    protected void validateUserForRelationshipReTyping(String userId, String metadataCollectionName, Relationship instance, TypeDefSummary newTypeDefSummary) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipReTyping";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForRelationshipReTyping");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForRelationshipReTyping");
            }
        }
    }

    protected void validateUserForRelationshipReHoming(String userId, String metadataCollectionName, Relationship instance, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws UserNotAuthorizedException {
        String methodName = "validateUserForRelationshipReHoming";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null) {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), type.getTypeDefName(), "validateUserForRelationshipReHoming");
            } else {
                this.throwUnauthorizedInstanceChange(userId, instance.getGUID(), "<Unknown>", "validateUserForRelationshipReHoming");
            }
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        this.logConnectorDisconnecting();
        super.disconnect();
    }
}

