/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceErrorCode;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;

public abstract class OMAGServerServiceInstance {
    protected String serverName;
    protected String serviceName;
    protected int maxPageSize = 500;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private OMAGServerPlatformInstanceMap platformInstanceMap = new OMAGServerPlatformInstanceMap();
    protected OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();

    @Deprecated
    public OMAGServerServiceInstance(String serverName, String serviceName) {
        this.serverName = serverName;
        this.serviceName = serviceName;
        this.invalidParameterHandler.setMaxPagingSize(this.maxPageSize);
        if (serverName != null) {
            this.platformInstanceMap.addServiceInstanceToPlatform(serverName, serviceName, this);
        }
    }

    public OMAGServerServiceInstance(String serverName, String serviceName, int maxPageSize) {
        this.serverName = serverName;
        this.serviceName = serviceName;
        this.maxPageSize = maxPageSize;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        if (serverName != null) {
            this.platformInstanceMap.addServiceInstanceToPlatform(serverName, serviceName, this);
        }
    }

    protected void setServerName(String serverName) {
        this.serverName = serverName;
        if (serverName != null) {
            this.platformInstanceMap.addServiceInstanceToPlatform(serverName, this.serviceName, this);
        }
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        OMAGServerInstanceErrorCode errorCode = OMAGServerInstanceErrorCode.SERVER_NAME_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("getServerName");
        throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getServerName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public InvalidParameterHandler getInvalidParameterHandler() {
        return this.invalidParameterHandler;
    }

    public void shutdown() {
        this.platformInstanceMap.removeServiceInstanceFromPlatform(this.serverName, this.serviceName);
    }
}

