/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.DataFieldHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.DiscoveryAnalysisReportHandler;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class ODFOMASServiceInstance
extends OCFOMASServiceInstance {
    protected AnnotationHandler annotationHandler;
    protected DataFieldHandler dataFieldHandler;
    protected DiscoveryAnalysisReportHandler discoveryAnalysisReportHandler;

    public ODFOMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, OMRSAuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(serviceName, repositoryConnector, supportedZones, defaultZones, auditLog, localServerUserId, maxPageSize);
        this.dataFieldHandler = new DataFieldHandler(serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper);
        this.annotationHandler = new AnnotationHandler(serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.dataFieldHandler);
        this.discoveryAnalysisReportHandler = new DiscoveryAnalysisReportHandler(serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.annotationHandler);
    }

    DiscoveryAnalysisReportHandler getDiscoveryAnalysisReportHandler() throws PropertyServerException {
        String methodName = "getDiscoveryAnalysisReportHandler";
        this.validateActiveRepository("getDiscoveryAnalysisReportHandler");
        return this.discoveryAnalysisReportHandler;
    }

    AnnotationHandler getAnnotationHandler() throws PropertyServerException {
        String methodName = "getAnnotationHandler";
        this.validateActiveRepository("getAnnotationHandler");
        return this.annotationHandler;
    }

    DataFieldHandler getDataFieldHandler() throws PropertyServerException {
        String methodName = "getDataFieldHandler";
        this.validateActiveRepository("getDataFieldHandler");
        return this.dataFieldHandler;
    }
}

