/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant.ffdc;

import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OMAGServerInstanceErrorCode {
    BAD_SERVER_SECURITY_CONNECTION(400, "OMAG-PLATFORM-400-001 ", "The OMAG server {0} has been configured with a bad connection to its security connector.  Error message is {1}. Connection is {2}", "The system is unable to validate the users issuing requests to this server.", "Review the error message to determine the cause of the problem."),
    SERVICES_NOT_SHUTDOWN(400, "OMAG-PLATFORM-400-002 ", "The OMAG server {0} has been requested to shutdown but the following services are still running: {1}", "The system is unable to shutdown the server correctly.", "Review other error messages to determine the cause of the problem.  This is likely to be a logic error in the services listed in the message"),
    SERVER_NOT_AVAILABLE(404, "OMAG-PLATFORM-404-001 ", "The OMAG Server {0} is not available to service a request from user {1}", "The system is unable to process the request.", "Retry the request when the OMAG Server is available."),
    SERVICE_NOT_AVAILABLE(404, "OMAG-PLATFORM-404-002 ", "The {0} service is not available on OMAG Server {1} to handle a request from user {2}", "The system is unable to process the request.", "Verify that the correct server is being called on the correct platform and that the requested service is configured to run there.  Once the correct environment is in place, retry the request."),
    SERVER_NAME_NOT_AVAILABLE(404, "OMAG-PLATFORM-404-003 ", "The server name is not available for the {0} operation", "The system is unable to connect to the open metadata repository.", "Check that the server where the access service is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    OMRS_NOT_INITIALIZED(404, "OMAG-PLATFORM-404-004 ", "The open metadata repository services are not initialized for the {0} operation", "The system is unable to connect to an open metadata repository.", "Check that the server where the access service is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    OMRS_NOT_AVAILABLE(404, "OMAG-PLATFORM-404-005 ", "The open metadata repository services are not available for the {0} operation", "The system is unable to connect to the open metadata repository.", "Check that the server where the access service is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private OMAGServerInstanceErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        log.debug(String.format("<== OMAGServerInstanceErrorCode.getMessage(%s)", Arrays.toString(params)));
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("==> OMAGServerInstanceErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String toString() {
        return "OMAGServerInstanceErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + '}';
    }

    static {
        log = LoggerFactory.getLogger(OMAGServerInstanceErrorCode.class);
    }
}

