/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.multitenant.AuditableServerServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceErrorCode;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OMASServiceInstance
extends AuditableServerServiceInstance {
    protected OMRSRepositoryConnector repositoryConnector;
    protected OMRSMetadataCollection metadataCollection;
    protected OMRSRepositoryHelper repositoryHelper;
    protected RepositoryHandler repositoryHandler;
    protected RepositoryErrorHandler errorHandler;
    protected List<String> supportedZones;
    protected List<String> defaultZones;
    protected List<String> publishZones;

    @Deprecated
    public OMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, AuditLog auditLog) throws NewInstanceException {
        this(serviceName, repositoryConnector, supportedZones, defaultZones, null, auditLog, null, 500);
    }

    @Deprecated
    public OMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog) throws NewInstanceException {
        this(serviceName, repositoryConnector, null, null, null, auditLog, null, 500);
    }

    public OMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        this(serviceName, repositoryConnector, null, null, null, auditLog, localServerUserId, maxPageSize);
    }

    OMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(null, serviceName, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (repositoryConnector != null) {
            try {
                this.repositoryConnector = repositoryConnector;
                this.setServerName(repositoryConnector.getServerName());
                this.metadataCollection = repositoryConnector.getMetadataCollection();
                this.repositoryHelper = repositoryConnector.getRepositoryHelper();
                this.errorHandler = new RepositoryErrorHandler(this.repositoryHelper, serviceName, this.serverName);
                this.repositoryHandler = new RepositoryHandler(auditLog, this.errorHandler, this.metadataCollection, maxPageSize);
                this.supportedZones = supportedZones;
                this.defaultZones = defaultZones;
                this.publishZones = publishZones;
            }
            catch (Throwable error) {
                throw new NewInstanceException(OMAGServerInstanceErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition("new ServiceInstance"), this.getClass().getName(), "new ServiceInstance");
            }
        } else {
            throw new NewInstanceException(OMAGServerInstanceErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition("new ServiceInstance"), this.getClass().getName(), "new ServiceInstance");
        }
    }

    @Override
    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        throw new NewInstanceException(OMAGServerInstanceErrorCode.OMRS_NOT_AVAILABLE.getMessageDefinition("getServerName"), this.getClass().getName(), "getServerName");
    }

    void validateActiveRepository(String methodName) throws PropertyServerException {
        if (this.repositoryConnector == null || this.metadataCollection == null || !this.repositoryConnector.isActive()) {
            throw new PropertyServerException(OMAGServerInstanceErrorCode.OMRS_NOT_AVAILABLE.getMessageDefinition(methodName), this.getClass().getName(), methodName);
        }
    }

    OMRSMetadataCollection getMetadataCollection() throws PropertyServerException {
        String methodName = "getMetadataCollection";
        this.validateActiveRepository("getMetadataCollection");
        return this.metadataCollection;
    }

    OMRSRepositoryConnector getRepositoryConnector() throws PropertyServerException {
        String methodName = "getRepositoryConnector";
        this.validateActiveRepository("getRepositoryConnector");
        return this.repositoryConnector;
    }

    OMRSRepositoryHelper getRepositoryHelper() throws PropertyServerException {
        String methodName = "getRepositoryHelper";
        this.validateActiveRepository("getRepositoryHelper");
        return this.repositoryHelper;
    }

    RepositoryHandler getRepositoryHandler() throws PropertyServerException {
        String methodName = "getRepositoryHandler";
        this.validateActiveRepository("getRepositoryHandler");
        return this.repositoryHandler;
    }

    RepositoryErrorHandler getErrorHandler() throws PropertyServerException {
        String methodName = "getErrorHandler";
        this.validateActiveRepository("getErrorHandler");
        return this.errorHandler;
    }

    List<String> getSupportedZones() throws PropertyServerException {
        String methodName = "getSupportedZones";
        this.validateActiveRepository("getSupportedZones");
        return this.supportedZones;
    }

    List<String> getDefaultZones() throws PropertyServerException {
        String methodName = "getDefaultZones";
        this.validateActiveRepository("getDefaultZones");
        return this.defaultZones;
    }

    List<String> getPublishZones() throws PropertyServerException {
        String methodName = "getPublishZones";
        this.validateActiveRepository("getPublishZones");
        return this.publishZones;
    }
}

