/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.multitenant.AuditableServerServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceAuditCode;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceErrorCode;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OMASServiceInstance
extends AuditableServerServiceInstance {
    protected OMRSRepositoryConnector repositoryConnector;
    protected OMRSMetadataCollection metadataCollection;
    protected OMRSRepositoryHelper repositoryHelper;
    protected RepositoryHandler repositoryHandler;
    protected RepositoryErrorHandler errorHandler;
    protected List<String> supportedZones;
    protected List<String> defaultZones;
    protected List<String> publishZones;
    private Connection inTopicEventBusConnection;
    private String inTopicConnectorProviderName;
    private Connection outTopicEventBusConnection;
    private String outTopicConnectorProviderName;
    private static final String serverIdPropertyName = "local.server.id";

    @Deprecated
    public OMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, AuditLog auditLog) throws NewInstanceException {
        this(serviceName, repositoryConnector, supportedZones, defaultZones, null, auditLog, null, 500);
    }

    @Deprecated
    public OMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog) throws NewInstanceException {
        this(serviceName, repositoryConnector, null, null, null, auditLog, null, 500);
    }

    public OMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        this(serviceName, repositoryConnector, null, null, null, auditLog, localServerUserId, maxPageSize);
    }

    public OMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        this(serviceName, repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, localServerUserId, maxPageSize, null, null, null, null);
    }

    public OMASServiceInstance(String serviceName, OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog, String localServerUserId, int maxPageSize, String inTopicConnectorProviderName, Connection inTopicEventBusConnection, String outTopicConnectorProviderName, Connection outTopicEventBusConnection) throws NewInstanceException {
        super(null, serviceName, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (repositoryConnector != null) {
            try {
                this.repositoryConnector = repositoryConnector;
                this.setServerName(repositoryConnector.getServerName());
                this.metadataCollection = repositoryConnector.getMetadataCollection();
                this.repositoryHelper = repositoryConnector.getRepositoryHelper();
                this.errorHandler = new RepositoryErrorHandler(this.repositoryHelper, serviceName, this.serverName, auditLog);
                this.repositoryHandler = new RepositoryHandler(auditLog, this.errorHandler, this.metadataCollection, maxPageSize);
                this.supportedZones = supportedZones;
                this.defaultZones = defaultZones;
                this.publishZones = publishZones;
                this.inTopicConnectorProviderName = inTopicConnectorProviderName;
                this.inTopicEventBusConnection = inTopicEventBusConnection;
                this.outTopicConnectorProviderName = outTopicConnectorProviderName;
                this.outTopicEventBusConnection = outTopicEventBusConnection;
            }
            catch (Throwable error) {
                throw new NewInstanceException(OMAGServerInstanceErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition("new ServiceInstance"), this.getClass().getName(), "new ServiceInstance");
            }
        } else {
            throw new NewInstanceException(OMAGServerInstanceErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition("new ServiceInstance"), this.getClass().getName(), "new ServiceInstance");
        }
    }

    @Override
    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        throw new NewInstanceException(OMAGServerInstanceErrorCode.OMRS_NOT_AVAILABLE.getMessageDefinition("getServerName"), this.getClass().getName(), "getServerName");
    }

    protected void validateActiveRepository(String methodName) throws PropertyServerException {
        if (this.repositoryConnector == null || this.metadataCollection == null || !this.repositoryConnector.isActive()) {
            throw new PropertyServerException(OMAGServerInstanceErrorCode.OMRS_NOT_AVAILABLE.getMessageDefinition(methodName), this.getClass().getName(), methodName);
        }
    }

    OMRSMetadataCollection getMetadataCollection() throws PropertyServerException {
        String methodName = "getMetadataCollection";
        this.validateActiveRepository("getMetadataCollection");
        return this.metadataCollection;
    }

    OMRSRepositoryConnector getRepositoryConnector() throws PropertyServerException {
        String methodName = "getRepositoryConnector";
        this.validateActiveRepository("getRepositoryConnector");
        return this.repositoryConnector;
    }

    OMRSRepositoryHelper getRepositoryHelper() throws PropertyServerException {
        String methodName = "getRepositoryHelper";
        this.validateActiveRepository("getRepositoryHelper");
        return this.repositoryHelper;
    }

    RepositoryHandler getRepositoryHandler() throws PropertyServerException {
        String methodName = "getRepositoryHandler";
        this.validateActiveRepository("getRepositoryHandler");
        return this.repositoryHandler;
    }

    RepositoryErrorHandler getErrorHandler() throws PropertyServerException {
        String methodName = "getErrorHandler";
        this.validateActiveRepository("getErrorHandler");
        return this.errorHandler;
    }

    List<String> getSupportedZones() throws PropertyServerException {
        String methodName = "getSupportedZones";
        this.validateActiveRepository("getSupportedZones");
        return this.supportedZones;
    }

    List<String> getDefaultZones() throws PropertyServerException {
        String methodName = "getDefaultZones";
        this.validateActiveRepository("getDefaultZones");
        return this.defaultZones;
    }

    List<String> getPublishZones() throws PropertyServerException {
        String methodName = "getPublishZones";
        this.validateActiveRepository("getPublishZones");
        return this.publishZones;
    }

    Connection getInTopicClientConnection(String callerId) throws PropertyServerException {
        String methodName = "getInTopicClientConnection";
        return this.getClientTopicConnection(callerId, this.inTopicEventBusConnection, this.inTopicConnectorProviderName, "getInTopicClientConnection");
    }

    Connection getOutTopicClientConnection(String callerId) throws PropertyServerException {
        String methodName = "getOutTopicClientConnection";
        return this.getClientTopicConnection(callerId, this.outTopicEventBusConnection, this.outTopicConnectorProviderName, "getOutTopicClientConnection");
    }

    private Connection getClientTopicConnection(String callerId, Connection topicEventBusConnection, String connectorProviderClassName, String methodName) throws PropertyServerException {
        if (topicEventBusConnection != null && connectorProviderClassName != null) {
            Connection newEventBusConnection = new Connection(topicEventBusConnection);
            HashMap<String, String> configurationProperties = newEventBusConnection.getConfigurationProperties();
            if (configurationProperties == null) {
                configurationProperties = new HashMap<String, String>();
            }
            configurationProperties.put(serverIdPropertyName, callerId);
            return this.buildClientTopicConnection(newEventBusConnection, connectorProviderClassName, methodName);
        }
        this.auditLog.logMessage(methodName, OMAGServerInstanceAuditCode.NO_TOPIC_INFORMATION.getMessageDefinition(methodName, this.serviceName));
        throw new PropertyServerException(OMAGServerInstanceErrorCode.NO_TOPIC_INFORMATION.getMessageDefinition(methodName, this.serviceName), this.getClass().getName(), methodName);
    }

    private Connection buildClientTopicConnection(Connection topicEventBusConnection, String accessServiceConnectorProviderClassName, String methodName) throws PropertyServerException {
        String connectionDescription = "Client-side topic connection.";
        String eventSource = "Topic Event Bus";
        ElementType elementType = VirtualConnection.getVirtualConnectionType();
        elementType.setElementOrigin(ElementOrigin.CONFIGURATION);
        String connectionName = "OutTopicConnector." + this.serviceName;
        VirtualConnection connection = new VirtualConnection();
        elementType = VirtualConnection.getVirtualConnectionType();
        connection.setType(elementType);
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("Client-side topic connection.");
        connection.setConnectorType(this.getConnectorType(accessServiceConnectorProviderClassName, methodName));
        EmbeddedConnection embeddedConnection = new EmbeddedConnection();
        embeddedConnection.setDisplayName("Topic Event Bus");
        embeddedConnection.setArguments(null);
        embeddedConnection.setEmbeddedConnection(topicEventBusConnection);
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        embeddedConnections.add(embeddedConnection);
        connection.setEmbeddedConnections(embeddedConnections);
        return connection;
    }

    private ConnectorType getConnectorType(String connectorProviderClassName, String methodName) throws PropertyServerException {
        ConnectorType connectorType = null;
        if (connectorProviderClassName != null) {
            try {
                Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
                Object potentialConnectorProvider = connectorProviderClass.newInstance();
                ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
                connectorType = connectorProvider.getConnectorType();
                if (connectorType == null) {
                    connectorType = new ConnectorType();
                    connectorType.setType(connectorType.getType());
                    connectorType.setQualifiedName(connectorProviderClassName);
                    connectorType.setDisplayName(connectorProviderClass.getSimpleName());
                    connectorType.setDescription("ConnectorType for " + connectorType.getDisplayName());
                    connectorType.setConnectorProviderClassName(connectorProviderClassName);
                }
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, OMAGServerInstanceAuditCode.BAD_TOPIC_CONNECTOR_PROVIDER.getMessageDefinition(methodName, this.serviceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                throw new PropertyServerException(OMAGServerInstanceErrorCode.BAD_TOPIC_CONNECTOR_PROVIDER.getMessageDefinition(methodName, this.serviceName, error.getClass().getName(), error.getMessage()), this.getClass().getName(), methodName);
            }
        }
        return connectorType;
    }
}

